/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.jdk.connector.internal;

import java.io.IOException;
import java.net.CookieManager;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import org.glassfish.jersey.SslConfigurator;
import org.glassfish.jersey.jdk.connector.internal.AsynchronousBodyInputStream;
import org.glassfish.jersey.jdk.connector.internal.ChunkedBodyOutputStream;
import org.glassfish.jersey.jdk.connector.internal.CompletionHandler;
import org.glassfish.jersey.jdk.connector.internal.ConnectorConfiguration;
import org.glassfish.jersey.jdk.connector.internal.Filter;
import org.glassfish.jersey.jdk.connector.internal.HttpFilter;
import org.glassfish.jersey.jdk.connector.internal.HttpRequest;
import org.glassfish.jersey.jdk.connector.internal.HttpResponse;
import org.glassfish.jersey.jdk.connector.internal.LocalizationMessages;
import org.glassfish.jersey.jdk.connector.internal.ProxyFilter;
import org.glassfish.jersey.jdk.connector.internal.SslFilter;
import org.glassfish.jersey.jdk.connector.internal.TransportFilter;
import org.glassfish.jersey.jdk.connector.internal.Utils;

class HttpConnection {
    private static final int SSL_INPUT_BUFFER_SIZE = 17000;
    private static final int INPUT_BUFFER_SIZE = 2048;
    private static final Logger LOGGER = Logger.getLogger(HttpConnection.class.getName());
    private final Filter<HttpRequest, HttpResponse, HttpRequest, HttpResponse> filterChain;
    private final CookieManager cookieManager;
    private final URI uri;
    private final StateChangeListener stateListener;
    private final ScheduledExecutorService scheduler;
    private final ConnectorConfiguration configuration;
    private HttpRequest httpRequest;
    private HttpResponse httResponse;
    private Throwable error;
    volatile State state = State.CREATED;
    private boolean persistentConnection = true;
    private Future<?> responseTimeout;
    private Future<?> idleTimeout;
    private Future<?> connectTimeout;

    HttpConnection(URI uri, CookieManager cookieManager, ConnectorConfiguration configuration, ScheduledExecutorService scheduler, StateChangeListener stateListener) {
        this.uri = uri;
        this.cookieManager = cookieManager;
        this.stateListener = stateListener;
        this.configuration = configuration;
        this.scheduler = scheduler;
        this.filterChain = this.createFilterChain(uri, configuration);
    }

    synchronized void connect() {
        if (this.state != State.CREATED) {
            throw new IllegalStateException(LocalizationMessages.HTTP_CONNECTION_ESTABLISHING_ILLEGAL_STATE((Object)this.state));
        }
        this.changeState(State.CONNECTING);
        this.scheduleConnectTimeout();
        this.filterChain.connect(new InetSocketAddress(this.uri.getHost(), Utils.getPort(this.uri)), null);
    }

    synchronized void send(HttpRequest httpRequest) {
        if (this.state != State.IDLE) {
            throw new IllegalStateException("Http request cannot be sent over a connection that is in other state than IDLE. Current state: " + (Object)((Object)this.state));
        }
        this.cancelIdleTimeout();
        this.httpRequest = httpRequest;
        this.httResponse = null;
        this.error = null;
        this.persistentConnection = true;
        this.changeState(State.SENDING_REQUEST);
        this.addRequestHeaders();
        this.filterChain.write(httpRequest, new CompletionHandler<HttpRequest>(){

            @Override
            public void failed(Throwable throwable) {
                HttpConnection.this.handleError(throwable);
            }

            @Override
            public void completed(HttpRequest result) {
                HttpConnection.this.handleHeaderSent();
            }
        });
    }

    void close() {
        if (this.state == State.CLOSED) {
            return;
        }
        this.cancelAllTimeouts();
        this.filterChain.close();
        this.changeState(State.CLOSED);
    }

    private synchronized void handleHeaderSent() {
        if (this.state != State.SENDING_REQUEST) {
            return;
        }
        this.scheduleResponseTimeout();
        if (this.httpRequest.getBodyMode() == HttpRequest.BodyMode.NONE || this.httpRequest.getBodyMode() == HttpRequest.BodyMode.BUFFERED) {
            this.changeState(State.RECEIVING_HEADER);
        } else {
            ChunkedBodyOutputStream bodyStream = (ChunkedBodyOutputStream)this.httpRequest.getBodyStream();
            bodyStream.setCloseListener(() -> {
                HttpConnection httpConnection = this;
                synchronized (httpConnection) {
                    if (this.state != State.SENDING_REQUEST) {
                        return;
                    }
                }
                this.changeState(State.RECEIVING_HEADER);
            });
        }
    }

    private void addRequestHeaders() {
        Map<String, List<String>> cookies;
        try {
            cookies = this.cookieManager.get(this.httpRequest.getUri(), this.httpRequest.getHeaders());
        }
        catch (IOException e) {
            this.handleError(e);
            return;
        }
        cookies.entrySet().stream().filter(cookieHeader -> cookieHeader.getValue() != null && !((List)cookieHeader.getValue()).isEmpty()).forEach(cookieHeader -> this.httpRequest.getHeaders().put((String)cookieHeader.getKey(), (List<String>)cookieHeader.getValue()));
    }

    private void processResponseHeaders(HttpResponse response) throws IOException {
        this.cookieManager.put(this.httpRequest.getUri(), this.httResponse.getHeaders());
        List<String> connectionValues = response.getHeader("Connection");
        if (connectionValues != null) {
            connectionValues.stream().filter(connectionValue -> connectionValue.equalsIgnoreCase("Close")).forEach(connectionValue -> {
                this.persistentConnection = false;
            });
        }
    }

    protected Filter<HttpRequest, HttpResponse, HttpRequest, HttpResponse> createFilterChain(URI uri, ConnectorConfiguration configuration) {
        Filter socket;
        boolean secure = "https".equals(uri.getScheme());
        if (secure) {
            SSLContext sslContext = configuration.getSslContext();
            TransportFilter transportFilter = new TransportFilter(17000, configuration.getThreadPoolConfig(), configuration.getContainerIdleTimeout());
            if (sslContext == null) {
                sslContext = SslConfigurator.getDefaultContext();
            }
            socket = new SslFilter(transportFilter, sslContext, uri.getHost(), configuration.getHostnameVerifier());
        } else {
            socket = new TransportFilter(2048, configuration.getThreadPoolConfig(), configuration.getContainerIdleTimeout());
        }
        int maxHeaderSize = configuration.getMaxHeaderSize();
        HttpFilter httpFilter = new HttpFilter(socket, maxHeaderSize, maxHeaderSize + 2048);
        ConnectorConfiguration.ProxyConfiguration proxyConfiguration = configuration.getProxyConfiguration();
        if (proxyConfiguration.isConfigured()) {
            ProxyFilter proxyFilter = new ProxyFilter(httpFilter, proxyConfiguration);
            return new ConnectionFilter(proxyFilter);
        }
        return new ConnectionFilter(httpFilter);
    }

    private void changeState(State newState) {
        if (this.state == State.CLOSED) {
            return;
        }
        State old = this.state;
        this.state = newState;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest(LocalizationMessages.CONNECTION_CHANGING_STATE(this.uri.getHost(), this.uri.getPort(), (Object)old, (Object)newState));
        }
        this.stateListener.onStateChanged(this, old, newState);
    }

    private void scheduleResponseTimeout() {
        if (this.configuration.getResponseTimeout() == 0) {
            return;
        }
        this.responseTimeout = this.scheduler.schedule(() -> {
            HttpConnection httpConnection = this;
            synchronized (httpConnection) {
                if (this.state != State.RECEIVING_HEADER && this.state != State.RECEIVING_BODY) {
                    return;
                }
                this.responseTimeout = null;
                this.changeState(State.RESPONSE_TIMEOUT);
                this.close();
            }
        }, (long)this.configuration.getResponseTimeout(), TimeUnit.MILLISECONDS);
    }

    private void cancelResponseTimeout() {
        if (this.responseTimeout != null) {
            this.responseTimeout.cancel(true);
            this.responseTimeout = null;
        }
    }

    private void scheduleConnectTimeout() {
        if (this.configuration.getConnectTimeout() == 0) {
            return;
        }
        this.connectTimeout = this.scheduler.schedule(() -> {
            HttpConnection httpConnection = this;
            synchronized (httpConnection) {
                if (this.state != State.CONNECTING) {
                    return;
                }
                this.connectTimeout = null;
                this.changeState(State.CONNECT_TIMEOUT);
                this.close();
            }
        }, (long)this.configuration.getConnectTimeout(), TimeUnit.MILLISECONDS);
    }

    private void cancelConnectTimeout() {
        if (this.connectTimeout != null) {
            this.connectTimeout.cancel(true);
            this.connectTimeout = null;
        }
    }

    private void scheduleIdleTimeout() {
        if (this.configuration.getConnectionIdleTimeout() == 0) {
            return;
        }
        this.idleTimeout = this.scheduler.schedule(() -> {
            HttpConnection httpConnection = this;
            synchronized (httpConnection) {
                if (this.state != State.IDLE) {
                    return;
                }
                this.idleTimeout = null;
                this.changeState(State.IDLE_TIMEOUT);
                this.close();
            }
        }, (long)this.configuration.getConnectionIdleTimeout(), TimeUnit.MILLISECONDS);
    }

    private void cancelIdleTimeout() {
        if (this.idleTimeout != null) {
            this.idleTimeout.cancel(true);
            this.idleTimeout = null;
        }
    }

    private void cancelAllTimeouts() {
        this.cancelConnectTimeout();
        this.cancelIdleTimeout();
        this.cancelResponseTimeout();
    }

    private synchronized void handleError(Throwable t) {
        this.cancelAllTimeouts();
        this.error = t;
        this.changeState(State.ERROR);
        this.close();
    }

    private void changeStateToIdle() {
        this.scheduleIdleTimeout();
        this.changeState(State.IDLE);
    }

    Throwable getError() {
        return this.error;
    }

    HttpResponse getHttResponse() {
        return this.httResponse;
    }

    private synchronized void handleResponseRead() {
        this.cancelResponseTimeout();
        this.changeState(State.RECEIVED);
        if (!this.persistentConnection) {
            this.changeState(State.CLOSED);
            return;
        }
        this.changeStateToIdle();
    }

    static interface StateChangeListener {
        public void onStateChanged(HttpConnection var1, State var2, State var3);
    }

    static enum State {
        CREATED,
        CONNECTING,
        CONNECT_TIMEOUT,
        IDLE,
        SENDING_REQUEST,
        RECEIVING_HEADER,
        RECEIVING_BODY,
        RECEIVED,
        RESPONSE_TIMEOUT,
        CLOSED_BY_SERVER,
        CLOSED,
        ERROR,
        IDLE_TIMEOUT;

    }

    private class ConnectionFilter
    extends Filter<HttpRequest, HttpResponse, HttpRequest, HttpResponse> {
        ConnectionFilter(Filter<HttpRequest, HttpResponse, ?, ?> downstreamFilter) {
            super(downstreamFilter);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        boolean processRead(HttpResponse response) {
            HttpConnection httpConnection = HttpConnection.this;
            synchronized (httpConnection) {
                if (HttpConnection.this.state != State.RECEIVING_HEADER && HttpConnection.this.state != State.SENDING_REQUEST) {
                    return false;
                }
                if (HttpConnection.this.state == State.SENDING_REQUEST) {
                    HttpConnection.this.changeState(State.RECEIVING_HEADER);
                }
                HttpConnection.this.httResponse = response;
                try {
                    HttpConnection.this.processResponseHeaders(response);
                }
                catch (IOException e) {
                    HttpConnection.this.handleError(e);
                    return false;
                }
            }
            if (response.getHasContent()) {
                AsynchronousBodyInputStream bodyStream = HttpConnection.this.httResponse.getBodyStream();
                HttpConnection.this.changeState(State.RECEIVING_BODY);
                bodyStream.setStateChangeLister(new AsynchronousBodyInputStream.StateChangeLister(){

                    @Override
                    public void onError(Throwable t) {
                        HttpConnection.this.handleError(t);
                    }

                    @Override
                    public void onAllDataRead() {
                        HttpConnection.this.handleResponseRead();
                    }
                });
            } else {
                HttpConnection.this.handleResponseRead();
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void processConnect() {
            HttpConnection httpConnection = HttpConnection.this;
            synchronized (httpConnection) {
                if (HttpConnection.this.state != State.CONNECTING) {
                    return;
                }
                this.downstreamFilter.startSsl();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void processSslHandshakeCompleted() {
            HttpConnection httpConnection = HttpConnection.this;
            synchronized (httpConnection) {
                if (HttpConnection.this.state != State.CONNECTING) {
                    return;
                }
                HttpConnection.this.cancelConnectTimeout();
                HttpConnection.this.changeStateToIdle();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void processConnectionClosed() {
            HttpConnection httpConnection = HttpConnection.this;
            synchronized (httpConnection) {
                HttpConnection.this.cancelAllTimeouts();
                HttpConnection.this.changeState(State.CLOSED_BY_SERVER);
                HttpConnection.this.close();
            }
        }

        @Override
        void processError(Throwable t) {
            HttpConnection.this.handleError(t);
        }

        @Override
        void write(HttpRequest data, CompletionHandler<HttpRequest> completionHandler) {
            this.downstreamFilter.write(data, completionHandler);
        }
    }
}

