/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote.container.model;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.mule.munit.common.util.Preconditions;
import org.mule.munit.remote.container.model.SuiteRun;

public class SuiteDeployment {
    private Set<SuiteRun> suiteRuns;
    private Map<String, String> systemProperties;
    private boolean enableXmlValidations;

    private SuiteDeployment(Set<SuiteRun> suiteRuns, Map<String, String> systemProperties, boolean enableXmlValidations) {
        this.suiteRuns = suiteRuns;
        this.systemProperties = systemProperties;
        this.enableXmlValidations = enableXmlValidations;
    }

    public Set<SuiteRun> getSuiteRuns() {
        return this.suiteRuns;
    }

    public boolean isEnableXmlValidations() {
        return this.enableXmlValidations;
    }

    public Map<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Set<SuiteRun> suiteRuns;
        private Map<String, String> systemProperties = new HashMap<String, String>();
        private boolean enableXmlValidations = true;

        private Builder() {
        }

        public Builder withSuiteRuns(Set<SuiteRun> suiteRuns) {
            Preconditions.checkArgument((suiteRuns != null ? 1 : 0) != 0, (String)"Suite runs cannot be null");
            Preconditions.checkArgument((!suiteRuns.isEmpty() ? 1 : 0) != 0, (String)"Suite runs cannot be empty");
            this.suiteRuns = suiteRuns;
            return this;
        }

        public Builder withSystemProperties(Map<String, String> systemProperties) {
            Preconditions.checkArgument((systemProperties != null ? 1 : 0) != 0, (String)"Parameterization name cannot be null");
            this.systemProperties = systemProperties;
            return this;
        }

        public Builder withEnableXmlValidations(boolean enableXmlValidations) {
            this.enableXmlValidations = enableXmlValidations;
            return this;
        }

        public SuiteDeployment build() {
            return new SuiteDeployment(this.suiteRuns, this.systemProperties, this.enableXmlValidations);
        }
    }
}

