/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.zip;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import javax.annotation.Nonnull;
import org.apache.commons.compress.archivers.zip.UnicodePathExtraField;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.utils.IOUtils;
import org.codehaus.plexus.archiver.AbstractUnArchiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.components.io.filemappers.FileMapper;
import org.codehaus.plexus.components.io.resources.PlexusIoResource;

public abstract class AbstractZipUnArchiver
extends AbstractUnArchiver {
    private static final String NATIVE_ENCODING = "native-encoding";
    private String encoding = "UTF8";

    public AbstractZipUnArchiver() {
    }

    public AbstractZipUnArchiver(File sourceFile) {
        super(sourceFile);
    }

    public void setEncoding(String encoding) {
        if (NATIVE_ENCODING.equals(encoding)) {
            encoding = null;
        }
        this.encoding = encoding;
    }

    @Override
    protected void execute() throws ArchiverException {
        this.getLogger().debug("Expanding: " + this.getSourceFile() + " into " + this.getDestDirectory());
        ZipFile zf = null;
        InputStream in = null;
        try {
            zf = new ZipFile(this.getSourceFile(), this.encoding, true);
            Enumeration<ZipArchiveEntry> e = zf.getEntriesInPhysicalOrder();
            while (e.hasMoreElements()) {
                ZipArchiveEntry ze = e.nextElement();
                ZipEntryFileInfo fileInfo = new ZipEntryFileInfo(zf, ze);
                if (!this.isSelected(fileInfo.getName(), fileInfo)) continue;
                in = zf.getInputStream(ze);
                this.extractFileIfIncluded(this.getSourceFile(), this.getDestDirectory(), in, fileInfo.getName(), new Date(ze.getTime()), ze.isDirectory(), ze.getUnixMode() != 0 ? Integer.valueOf(ze.getUnixMode()) : null, this.resolveSymlink(zf, ze), this.getFileMappers());
                in.close();
                in = null;
            }
            zf.close();
            zf = null;
            this.getLogger().debug("expand complete");
        }
        catch (IOException ioe) {
            try {
                throw new ArchiverException("Error while expanding " + this.getSourceFile().getAbsolutePath(), ioe);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly(zf);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(in);
        IOUtils.closeQuietly(zf);
    }

    private String resolveSymlink(ZipFile zf, ZipArchiveEntry ze) throws IOException {
        if (ze.isUnixSymlink()) {
            return zf.getUnixSymlink(ze);
        }
        return null;
    }

    private void extractFileIfIncluded(File sourceFile, File destDirectory, InputStream inputStream, String name, Date time, boolean isDirectory, Integer mode, String symlinkDestination, FileMapper[] fileMappers) throws IOException, ArchiverException {
        this.extractFile(sourceFile, destDirectory, inputStream, name, time, isDirectory, mode, symlinkDestination, fileMappers);
    }

    @Override
    protected void execute(String path, File outputDirectory) throws ArchiverException {
        ZipFile zipFile = null;
        InputStream in = null;
        try {
            zipFile = new ZipFile(this.getSourceFile(), this.encoding, true);
            Enumeration<ZipArchiveEntry> e = zipFile.getEntriesInPhysicalOrder();
            while (e.hasMoreElements()) {
                ZipArchiveEntry ze = e.nextElement();
                ZipEntryFileInfo fileInfo = new ZipEntryFileInfo(zipFile, ze);
                if (!this.isSelected(ze.getName(), fileInfo) || !ze.getName().startsWith(path)) continue;
                in = zipFile.getInputStream(ze);
                this.extractFileIfIncluded(this.getSourceFile(), outputDirectory, in, ze.getName(), new Date(ze.getTime()), ze.isDirectory(), ze.getUnixMode() != 0 ? Integer.valueOf(ze.getUnixMode()) : null, this.resolveSymlink(zipFile, ze), this.getFileMappers());
                in.close();
                in = null;
            }
            zipFile.close();
            zipFile = null;
        }
        catch (IOException ioe) {
            try {
                throw new ArchiverException("Error while expanding " + this.getSourceFile().getAbsolutePath(), ioe);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly(zipFile);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(in);
        IOUtils.closeQuietly(zipFile);
    }

    private static class ZipEntryFileInfo
    implements PlexusIoResource {
        private final ZipFile zipFile;
        private final ZipArchiveEntry zipEntry;

        ZipEntryFileInfo(ZipFile zipFile, ZipArchiveEntry zipEntry) {
            this.zipFile = zipFile;
            this.zipEntry = zipEntry;
        }

        @Override
        public String getName() {
            try {
                UnicodePathExtraField unicodePath = (UnicodePathExtraField)this.zipEntry.getExtraField(UnicodePathExtraField.UPATH_ID);
                return unicodePath != null ? new String(unicodePath.getUnicodeName(), "UTF-8") : this.zipEntry.getName();
            }
            catch (UnsupportedEncodingException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public boolean isDirectory() {
            return this.zipEntry.isDirectory();
        }

        @Override
        public boolean isFile() {
            return !this.zipEntry.isDirectory() && !this.zipEntry.isUnixSymlink();
        }

        @Override
        public boolean isSymbolicLink() {
            return this.zipEntry.isUnixSymlink();
        }

        @Override
        @Nonnull
        public InputStream getContents() throws IOException {
            return this.zipFile.getInputStream(this.zipEntry);
        }

        @Override
        public long getLastModified() {
            long l = this.zipEntry.getTime();
            return l == 0L ? 0L : l;
        }

        @Override
        public long getSize() {
            long l = this.zipEntry.getSize();
            return l == -1L ? -1L : l;
        }

        @Override
        public URL getURL() throws IOException {
            return null;
        }

        @Override
        public boolean isExisting() {
            return true;
        }
    }
}

