/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.jdk.connector.internal;

import java.net.CookieManager;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.glassfish.jersey.jdk.connector.internal.CompletionHandler;
import org.glassfish.jersey.jdk.connector.internal.ConnectorConfiguration;
import org.glassfish.jersey.jdk.connector.internal.DestinationConnectionPool;
import org.glassfish.jersey.jdk.connector.internal.HttpRequest;
import org.glassfish.jersey.jdk.connector.internal.HttpResponse;

class HttpConnectionPool {
    private static final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread thread = new Thread(r);
        thread.setDaemon(true);
        return thread;
    });
    private final ConnectorConfiguration connectorConfiguration;
    private final CookieManager cookieManager;
    private final Map<DestinationConnectionPool.DestinationKey, DestinationConnectionPool> destinationPools = new ConcurrentHashMap<DestinationConnectionPool.DestinationKey, DestinationConnectionPool>();

    HttpConnectionPool(ConnectorConfiguration connectorConfiguration, CookieManager cookieManager) {
        this.connectorConfiguration = connectorConfiguration;
        this.cookieManager = cookieManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void send(HttpRequest httpRequest, CompletionHandler<HttpResponse> completionHandler) {
        DestinationConnectionPool.DestinationKey destinationKey = new DestinationConnectionPool.DestinationKey(httpRequest.getUri());
        DestinationConnectionPool destinationConnectionPool = this.destinationPools.get(destinationKey);
        if (destinationConnectionPool == null) {
            HttpConnectionPool httpConnectionPool = this;
            synchronized (httpConnectionPool) {
                destinationConnectionPool = this.destinationPools.get(destinationKey);
                if (destinationConnectionPool == null) {
                    DestinationConnectionPool pool = new DestinationConnectionPool(this.connectorConfiguration, this.cookieManager, scheduler);
                    pool.setConnectionCloseListener(() -> this.destinationPools.remove(destinationKey, pool));
                    destinationConnectionPool = pool;
                    this.destinationPools.put(destinationKey, destinationConnectionPool);
                }
            }
        }
        destinationConnectionPool.send(httpRequest, completionHandler);
    }

    synchronized void close() {
        this.destinationPools.values().forEach(DestinationConnectionPool::close);
    }
}

