/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.jdk.connector.internal;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.List;
import org.glassfish.jersey.jdk.connector.internal.CompletionHandler;
import org.glassfish.jersey.jdk.connector.internal.ConnectorConfiguration;
import org.glassfish.jersey.jdk.connector.internal.Constants;
import org.glassfish.jersey.jdk.connector.internal.Filter;
import org.glassfish.jersey.jdk.connector.internal.HttpRequest;
import org.glassfish.jersey.jdk.connector.internal.HttpResponse;
import org.glassfish.jersey.jdk.connector.internal.LocalizationMessages;
import org.glassfish.jersey.jdk.connector.internal.ProxyAuthenticationException;
import org.glassfish.jersey.jdk.connector.internal.ProxyBasicAuthenticator;
import org.glassfish.jersey.jdk.connector.internal.ProxyDigestAuthenticator;

class ProxyFilter
extends Filter<HttpRequest, HttpResponse, HttpRequest, HttpResponse> {
    private final ConnectorConfiguration.ProxyConfiguration proxyConfiguration;
    private final ProxyDigestAuthenticator proxyDigestAuthenticator = new ProxyDigestAuthenticator();
    private volatile State state = State.CONNECTING;
    private volatile InetSocketAddress originalDestinationAddress;

    ProxyFilter(Filter<HttpRequest, HttpResponse, ?, ?> downstreamFilter, ConnectorConfiguration.ProxyConfiguration proxyConfiguration) {
        super(downstreamFilter);
        this.proxyConfiguration = proxyConfiguration;
    }

    @Override
    void connect(SocketAddress address, Filter<?, ?, HttpRequest, HttpResponse> upstreamFilter) {
        this.upstreamFilter = upstreamFilter;
        this.originalDestinationAddress = (InetSocketAddress)address;
        this.downstreamFilter.connect(new InetSocketAddress(this.proxyConfiguration.getHost(), this.proxyConfiguration.getPort()), this);
    }

    @Override
    void onConnect() {
        HttpRequest connect = this.createConnectRequest();
        this.downstreamFilter.write(connect, new CompletionHandler<HttpRequest>(){

            @Override
            public void failed(Throwable throwable) {
                ProxyFilter.this.upstreamFilter.processError(throwable);
            }
        });
    }

    @Override
    boolean processRead(HttpResponse httpResponse) {
        if (this.state == State.CONNECTED) {
            return true;
        }
        switch (httpResponse.getStatusCode()) {
            case 200: {
                this.state = State.CONNECTED;
                this.upstreamFilter.onConnect();
                break;
            }
            case 407: {
                if (this.state == State.AUTHENTICATED) {
                    this.upstreamFilter.onError(new ProxyAuthenticationException(LocalizationMessages.PROXY_407_TWICE()));
                    return false;
                }
                try {
                    this.state = State.AUTHENTICATED;
                    HttpRequest authenticatingRequest = this.createAuthenticatingRequest(httpResponse);
                    this.downstreamFilter.write(authenticatingRequest, new CompletionHandler<HttpRequest>(){

                        @Override
                        public void failed(Throwable throwable) {
                            ProxyFilter.this.upstreamFilter.processError(throwable);
                        }
                    });
                    break;
                }
                catch (ProxyAuthenticationException e) {
                    this.handleError(e);
                    return false;
                }
            }
            default: {
                this.handleError(new IOException(LocalizationMessages.PROXY_CONNECT_FAIL(httpResponse.getStatusCode())));
            }
        }
        return false;
    }

    @Override
    void write(HttpRequest data, CompletionHandler<HttpRequest> completionHandler) {
        this.downstreamFilter.write(data, completionHandler);
    }

    private void handleError(Throwable t2) {
        this.upstreamFilter.onError(t2);
    }

    private HttpRequest createAuthenticatingRequest(HttpResponse httpResponse) throws ProxyAuthenticationException {
        String authorizationHeader;
        String authenticateHeader = null;
        List<String> authHeader = httpResponse.getHeader("Proxy-Authenticate");
        if (authHeader != null && !authHeader.isEmpty()) {
            authenticateHeader = authHeader.get(0);
        }
        if (authenticateHeader == null || authenticateHeader.equals("")) {
            throw new ProxyAuthenticationException(LocalizationMessages.PROXY_MISSING_AUTH_HEADER());
        }
        String[] tokens = authenticateHeader.trim().split("\\s+", 2);
        String scheme = tokens[0];
        if ("Basic".equals(scheme)) {
            authorizationHeader = ProxyBasicAuthenticator.generateAuthorizationHeader(this.proxyConfiguration.getUserName(), this.proxyConfiguration.getPassword());
        } else if ("Digest".equals(scheme)) {
            String originalDestinationUri = this.getOriginalDestinationUri();
            URI uri = URI.create(originalDestinationUri);
            authorizationHeader = this.proxyDigestAuthenticator.generateAuthorizationHeader(uri, "CONNECT", authenticateHeader, this.proxyConfiguration.getUserName(), this.proxyConfiguration.getPassword());
        } else {
            throw new ProxyAuthenticationException(LocalizationMessages.PROXY_UNSUPPORTED_SCHEME(scheme));
        }
        HttpRequest connectRequest = this.createConnectRequest();
        connectRequest.addHeaderIfNotPresent("Proxy-Authorization", authorizationHeader);
        return connectRequest;
    }

    private HttpRequest createConnectRequest() {
        String originalDestinationUri = this.getOriginalDestinationUri();
        URI uri = URI.create(originalDestinationUri);
        HttpRequest connect = HttpRequest.createBodyless("CONNECT", uri);
        connect.addHeaderIfNotPresent(Constants.HOST, originalDestinationUri);
        connect.addHeaderIfNotPresent("ProxyConnection", "keep-alive");
        return connect;
    }

    private String getOriginalDestinationUri() {
        return String.format("%s:%d", this.originalDestinationAddress.getHostString(), this.originalDestinationAddress.getPort());
    }

    static enum State {
        CONNECTING,
        AUTHENTICATED,
        CONNECTED;

    }
}

