/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.muleclassloader.model.util;

import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;

public class DefaultMavenRepositoryLayoutUtils {
    public static String getPomFileName(Artifact artifact) {
        return DefaultMavenRepositoryLayoutUtils.buildMainPOMFileName(artifact) + ".pom";
    }

    public static String getFormattedFileName(Artifact artifact) {
        String destFileName = DefaultMavenRepositoryLayoutUtils.buildMainFileName(artifact);
        String extension = new DefaultArtifactHandler(artifact.getType()).getExtension();
        return destFileName + "." + extension;
    }

    private static String buildMainFileName(Artifact artifact) {
        String versionString = "-" + DefaultMavenRepositoryLayoutUtils.getNormalizedVersion(artifact);
        String classifierString = "";
        if (StringUtils.isNotBlank(artifact.getClassifier())) {
            classifierString = "-" + artifact.getClassifier();
        }
        return artifact.getArtifactId() + versionString + classifierString;
    }

    public static String buildMainPOMFileName(Artifact artifact) {
        String versionString = "-" + DefaultMavenRepositoryLayoutUtils.getNormalizedVersion(artifact);
        return artifact.getArtifactId() + versionString;
    }

    public static String getNormalizedVersion(Artifact artifact) {
        if (artifact.isSnapshot() && !artifact.getVersion().equals(artifact.getBaseVersion())) {
            return artifact.getBaseVersion();
        }
        return artifact.getVersion();
    }

    public static File getFormattedOutputDirectory(File outputDirectory, Artifact artifact) {
        StringBuilder sb = new StringBuilder();
        sb.append(artifact.getGroupId().replace('.', File.separatorChar)).append(File.separatorChar);
        sb.append(artifact.getArtifactId()).append(File.separatorChar);
        sb.append(artifact.getBaseVersion()).append(File.separatorChar);
        return new File(outputDirectory, sb.toString());
    }
}

