/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.packager.structure;

import com.google.common.base.Preconditions;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import org.mule.tools.api.packager.structure.FolderNames;

public class ProjectStructure {
    private final Path projectBaseFolder;
    private final Path projectBuildDirectory;
    private final boolean includeTestSuites;

    public ProjectStructure(Path projectBaseFolder, boolean includeTestSuites) {
        this(projectBaseFolder, Paths.get(FolderNames.TARGET.value(), new String[0]), includeTestSuites);
    }

    public ProjectStructure(Path projectBaseFolder, Path projectBuildFolder, boolean includeTestSuites) {
        Preconditions.checkArgument(projectBaseFolder != null, "Project base folder should not be null");
        Preconditions.checkArgument(projectBuildFolder != null, "Project build folder should not be null");
        this.projectBaseFolder = projectBaseFolder;
        this.projectBuildDirectory = projectBuildFolder;
        this.includeTestSuites = includeTestSuites;
    }

    public Path getProjectBaseFolder() {
        return this.projectBaseFolder;
    }

    public Path getExportedPackagesPath() {
        return this.projectBaseFolder.resolve(FolderNames.SRC.value()).resolve(FolderNames.MAIN.value()).resolve(FolderNames.JAVA.value());
    }

    public Path getConfigsPath() {
        return this.projectBaseFolder.resolve(FolderNames.SRC.value()).resolve(FolderNames.MAIN.value()).resolve(FolderNames.MULE.value());
    }

    public Optional<Path> getTestConfigsPath() {
        return this.includeTestSuites ? Optional.of(this.projectBaseFolder.resolve(FolderNames.SRC.value()).resolve(FolderNames.TEST.value()).resolve(FolderNames.MUNIT.value())) : Optional.empty();
    }

    public Optional<Path> getTestExportedResourcesPath() {
        return this.includeTestSuites ? Optional.of(this.projectBaseFolder.resolve(FolderNames.SRC.value()).resolve(FolderNames.TEST.value()).resolve(FolderNames.RESOURCES.value())) : Optional.empty();
    }

    public Path getMuleArtifactJsonPath() {
        return this.projectBuildDirectory.resolve(FolderNames.META_INF.value()).resolve(FolderNames.MULE_ARTIFACT.value());
    }

    public Path getOutputDirectory() {
        return this.projectBuildDirectory.resolve(FolderNames.CLASSES.value());
    }
}

