/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.verifier.policy;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.mule.runtime.api.deployment.meta.MuleApplicationModel;
import org.mule.runtime.api.deployment.persistence.MuleApplicationModelJsonSerializer;
import org.mule.tools.api.exception.ValidationException;
import org.mule.tools.api.packager.ProjectInformation;
import org.mule.tools.api.packager.packaging.Classifier;

class PolicyMuleArtifactJsonVerifier {
    private static final String GROUP_ID = "groupId";
    private static final String ARTIFACT_ID = "artifactId";
    private static final String VERSION = "version";
    private static final String CLASSIFIER = "classifier";
    private static final String TYPE = "type";
    private static final String JAR_TYPE = "jar";
    private static final String EXPORTED_PACKAGES = "exportedPackages";
    private static final String EXPORTED_RESOURCES = "exportedResources";
    private static final String CONFIGS = "configs";
    private static final String TEMPLATE_XML = "template.xml";
    private final ProjectInformation projectInformation;
    private final File file;

    public PolicyMuleArtifactJsonVerifier(ProjectInformation projectInformation, File file) {
        this.projectInformation = projectInformation;
        this.file = file;
    }

    public void validate() throws ValidationException {
        MuleApplicationModel muleArtifact = this.getMuleArtifact(this.file);
        this.checkAttributesPresent(this.projectInformation, muleArtifact);
        this.checkOnlyValidFields(muleArtifact);
    }

    private void checkOnlyValidFields(MuleApplicationModel muleApplicationModel) throws ValidationException {
        if (muleApplicationModel.getClassLoaderModelLoaderDescriptor() != null && muleApplicationModel.getClassLoaderModelLoaderDescriptor().getAttributes() != null) {
            Map attributes = muleApplicationModel.getClassLoaderModelLoaderDescriptor().getAttributes();
            this.validCondition(this.checkNullOrEmptyCollection(attributes.get(EXPORTED_PACKAGES)), this.mustNotDefineFieldMessage(EXPORTED_PACKAGES));
            this.validCondition(this.checkNullOrEmptyCollection(attributes.get(EXPORTED_RESOURCES)), this.mustNotDefineFieldMessage(EXPORTED_RESOURCES));
        }
        this.validCondition(this.checkConfigsElementIsValid(muleApplicationModel.getConfigs()), this.mustNotDefineFieldMessage(CONFIGS));
    }

    private void checkAttributesPresent(ProjectInformation projectInformation, MuleApplicationModel muleApplicationModel) throws ValidationException {
        if (muleApplicationModel.getBundleDescriptorLoader() != null && muleApplicationModel.getBundleDescriptorLoader().getAttributes() != null) {
            Map attributes = muleApplicationModel.getBundleDescriptorLoader().getAttributes();
            this.validCondition(!attributes.containsKey(GROUP_ID) || projectInformation.getGroupId().equals(attributes.get(GROUP_ID)), this.mismatchFieldWithPomMessage(GROUP_ID, projectInformation.getGroupId(), attributes.get(GROUP_ID)));
            this.validCondition(!attributes.containsKey(ARTIFACT_ID) || projectInformation.getArtifactId().equals(attributes.get(ARTIFACT_ID)), this.mismatchFieldWithPomMessage(ARTIFACT_ID, projectInformation.getArtifactId(), attributes.get(ARTIFACT_ID)));
            this.validCondition(!attributes.containsKey(VERSION) || projectInformation.getVersion().equals(attributes.get(VERSION)), this.mismatchFieldWithPomMessage(VERSION, projectInformation.getVersion(), attributes.get(VERSION)));
            this.validCondition(!attributes.containsKey(CLASSIFIER) || Classifier.MULE_POLICY.toString().equals(attributes.get(CLASSIFIER)), this.mismatchExpectedFieldValue(CLASSIFIER, Classifier.MULE_POLICY.toString(), attributes.get(CLASSIFIER)));
            this.validCondition(JAR_TYPE.equals(attributes.getOrDefault(TYPE, JAR_TYPE)), this.mismatchExpectedFieldValue(TYPE, JAR_TYPE, attributes.get(TYPE)));
        }
    }

    private Boolean checkNullOrEmptyCollection(Object object) {
        return object == null || object instanceof Collection && ((Collection)object).isEmpty();
    }

    private Boolean checkConfigsElementIsValid(Object object) {
        return object == null || object instanceof Collection && ((Collection)object).isEmpty() || object instanceof Collection && ((Collection)object).size() == 1 && ((Collection)object).contains(TEMPLATE_XML);
    }

    private MuleApplicationModel getMuleArtifact(File file) throws ValidationException {
        try {
            return (MuleApplicationModel)new MuleApplicationModelJsonSerializer().deserialize(FileUtils.readFileToString(file, (String)null));
        }
        catch (IOException e) {
            throw new ValidationException(String.format("Error validating '%s'. %s", file.getName(), e.getMessage()));
        }
    }

    private String mustNotDefineFieldMessage(String field) {
        return String.format("The field %s must not be defined or be empty.", field);
    }

    private String mismatchFieldWithPomMessage(String field, String expectedValue, Object actualValue) {
        return String.format("The %s does not match the one defined in the pom.xml. Expected '%s'. Actual '%s'.", field, expectedValue, actualValue);
    }

    private String mismatchExpectedFieldValue(String fieldName, String expectedValue, Object actualValue) {
        return String.format("The field '%s' had an unexpected value. Expected '%s'. Actual '%s'.", fieldName, expectedValue, actualValue);
    }

    private void validCondition(Boolean condition, String message) throws ValidationException {
        try {
            Preconditions.checkArgument(condition, message);
        }
        catch (Exception e) {
            throw new ValidationException(String.format("Error in file '%s'. %s", this.file.getName(), e.getMessage()));
        }
    }
}

