/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.validation;

import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.mule.tools.client.core.exception.DeploymentException;
import org.mule.tools.model.Deployment;
import org.mule.tools.validation.EnvironmentSupportedVersions;

public abstract class AbstractDeploymentValidator {
    protected final Deployment deployment;
    private final Supplier<DeploymentException> deploymentExceptionSupplier = () -> new DeploymentException("muleVersion is not present in deployment configuration");

    public AbstractDeploymentValidator(Deployment deployment) {
        this.deployment = deployment;
    }

    public void validateMuleVersionAgainstEnvironment() throws DeploymentException {
        String deploymentMuleVersion = this.deployment.getMuleVersion().orElseThrow(this.deploymentExceptionSupplier);
        EnvironmentSupportedVersions environmentVersion = this.getEnvironmentSupportedVersions();
        if (!environmentVersion.supports(deploymentMuleVersion)) {
            throw new DeploymentException(String.format("muleVersion \"%s\" is not supported, supported versions: %s", deploymentMuleVersion, StringUtils.join(environmentVersion.getEnvironmentSupportedVersions(), ", ")));
        }
    }

    public abstract EnvironmentSupportedVersions getEnvironmentSupportedVersions() throws DeploymentException;
}

