/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote;

import com.evanlennick.retry4j.CallExecutorBuilder;
import com.evanlennick.retry4j.config.RetryConfig;
import com.evanlennick.retry4j.config.RetryConfigBuilder;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.time.temporal.ChronoUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MuleDxMunitLock {
    private static final Logger LOGGER = LogManager.getLogger(MuleDxMunitLock.class);
    private final FileChannel channel;
    final File file;
    private FileLock lock;

    public MuleDxMunitLock(String lockId) {
        this.file = new File(System.getProperty("java.io.tmpdir"), lockId + ".tmp");
        try {
            this.channel = new RandomAccessFile(this.file, "rw").getChannel();
        }
        catch (Exception exception) {
            LOGGER.error(exception.getMessage(), (Throwable)exception);
            throw new RuntimeException(exception);
        }
    }

    public void lock() {
        this.lock(25);
    }

    public void lock(int tries) {
        RetryConfig config = new RetryConfigBuilder().retryOnAnyException().withMaxNumberOfTries(tries).withDelayBetweenTries(2L, ChronoUnit.SECONDS).withExponentialBackoff().build();
        new CallExecutorBuilder().config(config).build().execute(() -> {
            try {
                LOGGER.debug("Attempting to connect lock file." + this.file.getAbsolutePath());
                this.lock = this.channel.tryLock();
                if (this.lock == null) {
                    throw new IllegalStateException();
                }
            }
            catch (IllegalStateException exception) {
                throw exception;
            }
            catch (Exception exception) {
                LOGGER.error("Unexpected exception. Lock not be possible", (Throwable)exception);
            }
            return null;
        });
    }

    public void release() {
        try {
            if (this.lock != null) {
                this.lock.release();
                this.channel.close();
            }
        }
        catch (Exception exception) {
            LOGGER.error(exception.getMessage(), (Throwable)exception);
            throw new RuntimeException(exception);
        }
    }
}

