/*
 * Decompiled with CFR 0.152.
 */
package org.mule.maven.client.internal;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.UnsolvableVersionConflictException;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.util.artifact.ArtifactIdUtils;
import org.eclipse.aether.util.graph.transformer.ConflictResolver;
import org.eclipse.aether.util.graph.transformer.NearestVersionSelector;
import org.eclipse.aether.util.graph.visitor.PathRecordingDependencyVisitor;
import org.mule.maven.client.api.exception.IncompatibleMulePluginVersionResolutionException;
import org.mule.maven.client.internal.util.VersionChecker;

public class MuleVersionSelector
extends ConflictResolver.VersionSelector {
    private NearestVersionSelector nearestVersionSelector;

    public MuleVersionSelector(NearestVersionSelector nearestVersionSelector) {
        this.nearestVersionSelector = nearestVersionSelector;
    }

    @Override
    public void selectVersion(ConflictResolver.ConflictContext context) throws RepositoryException {
        if (context.getItems().stream().allMatch(conflictItem -> conflictItem.getNode().getArtifact().getClassifier().equals("mule-plugin"))) {
            ConflictResolver.ConflictItem winner = null;
            for (ConflictResolver.ConflictItem item : context.getItems()) {
                String winnerVersion;
                String itemVersion;
                if (item.getNode().getVersionConstraint().getRange() != null) {
                    throw this.newVersionRangeNotSupportedFailure(item.getNode().getArtifact(), context);
                }
                if (winner == null) {
                    winner = item;
                }
                if (!VersionChecker.areCompatibleVersions(itemVersion = item.getNode().getVersion().toString(), winnerVersion = winner.getNode().getVersion().toString())) {
                    throw this.newIncompatibleMulePluginVersionFailure(item.getNode().getArtifact(), winner.getNode().getArtifact(), context);
                }
                if (!VersionChecker.isHighestVersion(itemVersion, winnerVersion)) continue;
                winner = item;
            }
            context.setWinner(winner);
        } else {
            this.nearestVersionSelector.selectVersion(context);
        }
    }

    private IllegalArgumentException newVersionRangeNotSupportedFailure(Artifact artifact, ConflictResolver.ConflictContext context) {
        List<List<DependencyNode>> paths = this.getConflictContextPaths(context);
        return new IllegalArgumentException(String.format("Version ranges for Mule plugin dependencies (%s) are not supported, semantic version is supported instead", ArtifactIdUtils.toId(artifact)), new UnsolvableVersionConflictException(paths));
    }

    private IncompatibleMulePluginVersionResolutionException newIncompatibleMulePluginVersionFailure(Artifact candidateArtifact, Artifact winnerArtifact, ConflictResolver.ConflictContext context) {
        return new IncompatibleMulePluginVersionResolutionException(ArtifactIdUtils.toId(candidateArtifact), ArtifactIdUtils.toId(winnerArtifact), MuleVersionSelector.toPaths(this.getConflictContextPaths(context)));
    }

    private List<List<DependencyNode>> getConflictContextPaths(ConflictResolver.ConflictContext context) {
        DependencyFilter filter = (node, parents) -> context.isIncluded(node);
        PathRecordingDependencyVisitor visitor = new PathRecordingDependencyVisitor(filter);
        context.getRoot().accept(visitor);
        return visitor.getPaths();
    }

    private static String toPaths(Collection<List<DependencyNode>> paths) {
        String result = "";
        if (paths != null) {
            LinkedHashSet<String> strings = new LinkedHashSet<String>();
            for (List<DependencyNode> path : paths) {
                strings.add(MuleVersionSelector.toPath(path));
            }
            result = ((Object)strings).toString();
        }
        return result;
    }

    private static String toPath(List<DependencyNode> path) {
        StringBuilder buffer = new StringBuilder(256);
        Iterator<DependencyNode> it = path.iterator();
        while (it.hasNext()) {
            DependencyNode node = it.next();
            if (node.getDependency() == null) continue;
            Artifact artifact = node.getDependency().getArtifact();
            buffer.append(artifact.getGroupId());
            buffer.append(':').append(artifact.getArtifactId());
            buffer.append(':').append(artifact.getExtension());
            if (artifact.getClassifier().length() > 0) {
                buffer.append(':').append(artifact.getClassifier());
            }
            buffer.append(':').append(node.getVersionConstraint());
            if (!it.hasNext()) continue;
            buffer.append(" -> ");
        }
        return buffer.toString();
    }
}

