/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote.api.configuration;

import com.google.gson.Gson;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import org.mule.munit.remote.api.configuration.RunConfiguration;

public class RunConfigurationParser {
    public static final String RUN_CONFIGURATION_PARAMETER = "run_configuration";
    private static final int MIN_PORT_NUMBER = 50000;
    private static final int MAX_PORT_NUMBER = 55000;

    public RunConfiguration parse(String[] args) throws ParseException, IOException {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-run_configuration")) continue;
            return this.buildRunConfiguration(args[i + 1]);
        }
        throw new ParseException("run configuration not found", 0);
    }

    private RunConfiguration buildRunConfiguration(String file) throws IOException {
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);
        return new Gson().fromJson((Reader)reader, RunConfiguration.class);
    }
}

