/*
 * Decompiled with CFR 0.152.
 */
package com.evanlennick.retry4j.config;

import com.evanlennick.retry4j.backoff.BackoffStrategy;
import java.time.Duration;
import java.util.Set;
import java.util.function.Function;

public class RetryConfig {
    private final boolean retryOnAnyException;
    private final Set<Class<? extends Exception>> retryOnSpecificExceptions;
    private final Set<Class<? extends Exception>> retryOnAnyExceptionExcluding;
    private final Integer maxNumberOfTries;
    private final Duration delayBetweenRetries;
    private final BackoffStrategy backoffStrategy;
    private final Object valueToRetryOn;
    private final boolean retryOnValue;
    private final Function<Exception, Boolean> customRetryOnLogic;
    private final boolean retryOnCausedBy;

    RetryConfig(boolean retryOnAnyException, Set<Class<? extends Exception>> retryOnSpecificExceptions, Set<Class<? extends Exception>> retryOnAnyExceptionExcluding, Integer maxNumberOfTries, Duration delayBetweenRetries, BackoffStrategy backoffStrategy, Object valueToRetryOn, boolean retryOnValue, Function<Exception, Boolean> customRetryOnLogic, boolean retryOnCausedBy) {
        this.retryOnAnyException = retryOnAnyException;
        this.retryOnSpecificExceptions = retryOnSpecificExceptions;
        this.retryOnAnyExceptionExcluding = retryOnAnyExceptionExcluding;
        this.maxNumberOfTries = maxNumberOfTries;
        this.delayBetweenRetries = delayBetweenRetries;
        this.backoffStrategy = backoffStrategy;
        this.valueToRetryOn = valueToRetryOn;
        this.retryOnValue = retryOnValue;
        this.customRetryOnLogic = customRetryOnLogic;
        this.retryOnCausedBy = retryOnCausedBy;
    }

    public Object getValueToRetryOn() {
        return this.valueToRetryOn;
    }

    public boolean shouldRetryOnValue() {
        return this.retryOnValue;
    }

    public boolean isRetryOnAnyException() {
        return this.retryOnAnyException;
    }

    public Set<Class<? extends Exception>> getRetryOnSpecificExceptions() {
        return this.retryOnSpecificExceptions;
    }

    public Set<Class<? extends Exception>> getRetryOnAnyExceptionExcluding() {
        return this.retryOnAnyExceptionExcluding;
    }

    public boolean shouldRetryOnCausedBy() {
        return this.retryOnCausedBy;
    }

    public Integer getMaxNumberOfTries() {
        return this.maxNumberOfTries;
    }

    public BackoffStrategy getBackoffStrategy() {
        return this.backoffStrategy;
    }

    public Function<Exception, Boolean> getCustomRetryOnLogic() {
        return this.customRetryOnLogic;
    }

    public Duration getDelayBetweenRetries() {
        return this.delayBetweenRetries;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("RetryConfig{");
        sb.append("retryOnAnyException=").append(this.retryOnAnyException);
        sb.append(", retryOnSpecificExceptions=").append(this.retryOnSpecificExceptions);
        sb.append(", retryOnAnyExceptionExcluding=").append(this.retryOnAnyExceptionExcluding);
        sb.append(", maxNumberOfTries=").append(this.maxNumberOfTries);
        sb.append(", delayBetweenRetries=").append(this.delayBetweenRetries);
        sb.append(", backoffStrategy=").append(this.backoffStrategy);
        sb.append(", valueToRetryOn=").append(this.valueToRetryOn);
        sb.append(", retryOnValue=").append(this.retryOnValue);
        sb.append(", customRetryOnLogic=").append(this.customRetryOnLogic);
        sb.append('}');
        return sb.toString();
    }
}

