/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote;

import java.io.File;
import java.util.Set;
import org.mule.munit.remote.api.configuration.RunConfiguration;
import org.mule.munit.remote.container.ContainerSuiteRunDispatcher;
import org.mule.munit.remote.container.EmbeddedContainerFactory;
import org.mule.munit.remote.container.SuiteRunDispatcher;
import org.mule.munit.remote.container.SuiteRunLocator;
import org.mule.munit.remote.container.model.SuiteRun;

public class SuiteRunDispatcherFactory {
    private final RunConfiguration runConfiguration;
    private final EmbeddedContainerFactory embeddedContainerFactory;

    public SuiteRunDispatcherFactory(RunConfiguration runConfiguration, EmbeddedContainerFactory embeddedContainerFactory) {
        this.runConfiguration = runConfiguration;
        this.embeddedContainerFactory = embeddedContainerFactory;
    }

    public SuiteRunDispatcher create() {
        File appDir = new File(this.runConfiguration.getContainerConfiguration().getMunitWorkingDirectoryPath(), this.runConfiguration.getProjectName());
        Set<SuiteRun> suiteRuns = new SuiteRunLocator(this.runConfiguration, appDir).locate();
        return new ContainerSuiteRunDispatcher(this.embeddedContainerFactory.createContainer(this.runConfiguration), this.runConfiguration, suiteRuns, appDir);
    }
}

