/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.remote.api.configuration;

/**
 * This class defines the configuration of the debugger
 *
 * @author Mulesoft Inc.
 */
public class DebuggerConfiguration {

  private final Integer debuggerPort;
  private final String lockKey;
  private final Integer lockTries;

  public DebuggerConfiguration(Integer debuggerPort, String lockKey, Integer lockTries) {
    this.debuggerPort = debuggerPort;
    this.lockKey = lockKey;
    this.lockTries = lockTries;
  }

  public Integer getDebuggerPort() {
    return debuggerPort;
  }

  public String getLockKey() {
    return lockKey;
  }

  public Integer getLockTries() {
    return lockTries;
  }
}
