/*
 * Decompiled with CFR 0.152.
 */
package com.evanlennick.retry4j.backoff;

import com.evanlennick.retry4j.backoff.BackoffStrategy;
import com.evanlennick.retry4j.backoff.ExponentialBackoffStrategy;
import com.evanlennick.retry4j.backoff.RandomBackoffStrategy;
import com.evanlennick.retry4j.config.RetryConfig;
import com.evanlennick.retry4j.exception.InvalidRetryConfigException;
import java.time.Duration;

public class RandomExponentialBackoffStrategy
implements BackoffStrategy {
    private RandomBackoffStrategy randomBackoffStrategy = new RandomBackoffStrategy(10);
    private ExponentialBackoffStrategy exponentialBackoffStrategy = new ExponentialBackoffStrategy();

    @Override
    public Duration getDurationToWait(int numberOfTriesFailed, Duration delayBetweenAttempts) {
        Duration durationWaitFromExpBackoff = this.exponentialBackoffStrategy.getDurationToWait(numberOfTriesFailed, delayBetweenAttempts);
        return this.randomBackoffStrategy.getDurationToWait(numberOfTriesFailed, durationWaitFromExpBackoff);
    }

    @Override
    public void validateConfig(RetryConfig config) {
        if (null == config.getDelayBetweenRetries()) {
            throw new InvalidRetryConfigException("Retry config must specify the delay between retries!");
        }
    }
}

