/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote.coverage.server;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mule.munit.common.util.Preconditions;
import org.mule.munit.remote.coverage.server.CoverageLocationsAccumulator;
import org.mule.munit.remote.coverage.server.CoverageMessageParser;
import org.mule.munit.remote.coverage.server.Latch;

public class CoverageServer {
    private static final int SOCKET_TIMEOUT_MILLIS = 1800000;
    private transient Logger log = LogManager.getLogger(this.getClass());
    private Integer port;
    private Boolean running = false;
    private Boolean keepRunning = true;
    private Latch startLatch = new Latch();
    private Thread serverThread;
    private ServerSocket providerSocket = null;
    private CoverageLocationsAccumulator coverageLocationsAccumulator;

    public CoverageServer(Integer port, CoverageLocationsAccumulator coverageLocationsAccumulator) {
        Preconditions.checkNotNull(port, "The port can not be null.");
        Preconditions.checkArgument(port > 0, "The port must be a positive number.");
        Preconditions.checkNotNull(coverageLocationsAccumulator, "The report accumulator must not be null.");
        this.port = port;
        this.coverageLocationsAccumulator = coverageLocationsAccumulator;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void launch() {
        if (this.running.booleanValue()) {
            throw new RuntimeException("The Coverage server is already running it can not be started again.");
        }
        this.serverThread = new ServerThread();
        Executors.newSingleThreadExecutor().execute(this.serverThread);
        try {
            this.startLatch.await(1800000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException cause) {
            throw new RuntimeException("Coverage server was interrupted when starting", cause);
        }
    }

    public void shutDown() {
        this.doShutdown();
        if (this.serverThread != null && !this.serverThread.isInterrupted()) {
            this.serverThread.interrupt();
        }
    }

    private void doShutdown() {
        try {
            this.log.debug("Shutting down coverage server running in port [" + this.port + "]...");
            this.running = false;
            this.keepRunning = false;
            if (null != this.providerSocket) {
                this.providerSocket.close();
            }
            this.log.debug("Coverage server shutdown");
        }
        catch (IOException ioException) {
            this.log.debug("Coverage Server error during shut down.", (Throwable)ioException);
        }
    }

    private class ServerThread
    extends Thread {
        private ServerThread() {
        }

        @Override
        public void run() {
            CoverageServer.this.log.info("Coverage Server starting...");
            CoverageServer.this.running = true;
            CoverageServer.this.keepRunning = true;
            try {
                CoverageServer.this.providerSocket = new ServerSocket(CoverageServer.this.port, 10);
                CoverageServer.this.providerSocket.setSoTimeout(1800000);
                CoverageServer.this.log.info("Waiting for coverage client connection in port [" + CoverageServer.this.port + "]...");
                CoverageServer.this.startLatch.countDown();
                do {
                    Socket connection = CoverageServer.this.providerSocket.accept();
                    CoverageServer.this.log.info("Coverage client connection received from " + connection.getInetAddress().getHostName() + " - " + CoverageServer.this.keepRunning);
                    CoverageMessageParser parser = new CoverageMessageParser(new ObjectInputStream(connection.getInputStream()), CoverageServer.this.coverageLocationsAccumulator);
                    Executors.newSingleThreadExecutor().execute(parser);
                } while (CoverageServer.this.keepRunning.booleanValue());
            }
            catch (SocketTimeoutException timeoutException) {
                CoverageServer.this.log.warn("Coverage Server time out");
                if (CoverageServer.this.keepRunning.booleanValue()) {
                    CoverageServer.this.log.error("Coverage Server connection timeout after " + String.valueOf(1800000) + " milliseconds");
                }
            }
            catch (IOException ioException) {
                if (CoverageServer.this.keepRunning.booleanValue()) {
                    CoverageServer.this.log.error("Failed to start Coverage Server in port " + CoverageServer.this.port, (Throwable)ioException);
                }
            }
            finally {
                CoverageServer.this.doShutdown();
            }
        }
    }
}

