/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote.runtime.utils;

import com.vdurmont.semver4j.Semver;
import com.vdurmont.semver4j.SemverException;

public final class MuleVersion {
    public static final int NO_REVISION = -1;
    private Semver semver;

    public MuleVersion(String version) {
        this.parse(version);
    }

    public String toString() {
        return this.semver.toString();
    }

    private void parse(String version) {
        try {
            this.semver = new Semver(version, Semver.SemverType.LOOSE);
            if (this.semver.getMajor() == null || this.semver.getMinor() == null) {
                throw new IllegalArgumentException("Invalid version " + version);
            }
        }
        catch (SemverException var3) {
            throw new IllegalArgumentException("Invalid version " + version);
        }
    }

    public boolean atLeast(String version) {
        return this.atLeast(new MuleVersion(version));
    }

    public boolean atLeast(MuleVersion version) {
        return this.equals(version) || this.newerThan(version);
    }

    public boolean atLeastBase(String baseVersion) {
        return this.getBaseVersion().atLeastBase(new MuleVersion(baseVersion));
    }

    public boolean atLeastBase(MuleVersion baseVersion) {
        return this.getBaseVersion().atLeast(baseVersion.getBaseVersion());
    }

    public boolean sameBaseVersion(MuleVersion otherVersion) {
        return this.getBaseVersion().sameAs(otherVersion.getBaseVersion());
    }

    public boolean sameAs(String version) {
        return this.sameAs(new MuleVersion(version));
    }

    public boolean sameAs(MuleVersion version) {
        return this.equals(version);
    }

    public boolean priorTo(String version) {
        return this.priorTo(new MuleVersion(version));
    }

    public boolean priorTo(MuleVersion version) {
        return !this.atLeast(version);
    }

    public boolean newerThan(String version) {
        return this.newerThan(new MuleVersion(version));
    }

    public boolean newerThan(MuleVersion version) {
        if (this.getMajor() > version.getMajor()) {
            return true;
        }
        if (this.getMajor() == version.getMajor()) {
            if (this.getMinor() > version.getMinor()) {
                return true;
            }
            if (this.getMinor() == version.getMinor()) {
                if (this.getRevision() > version.getRevision()) {
                    return true;
                }
                if (this.getRevision() == version.getRevision() || this.getRevision() <= 0 && version.getRevision() <= 0) {
                    if (!this.hasSuffix() && version.hasSuffix()) {
                        return true;
                    }
                    if (this.hasSuffix() && version.hasSuffix()) {
                        return this.getSuffix().compareToIgnoreCase(version.getSuffix()) > 0;
                    }
                }
            }
        }
        return false;
    }

    public String toCompleteNumericVersion() {
        return this.semver.getMajor() + "." + this.semver.getMinor() + "." + (this.semver.getPatch() != null ? this.semver.getPatch() : 0);
    }

    public MuleVersion withoutSuffixes() {
        return new MuleVersion(this.toCompleteNumericVersion());
    }

    public boolean hasSuffix() {
        return this.semver.getSuffixTokens() != null && this.semver.getSuffixTokens().length > 0;
    }

    private MuleVersion getBaseVersion() {
        return new MuleVersion(this.getMajor() + "." + this.getMinor());
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        return !(otherObject instanceof MuleVersion) ? false : this.toString().equals(otherObject.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public int getMajor() {
        return this.semver.getMajor();
    }

    public void setMajor(int major) {
        this.semver.withIncMajor(-1 * this.semver.getMajor() + major);
    }

    public int getMinor() {
        return this.semver.getMinor();
    }

    public void setMinor(int minor) {
        this.semver.withIncMinor(-1 * this.semver.getMinor() + minor);
    }

    public int getRevision() {
        return this.semver.getPatch() != null ? this.semver.getPatch() : -1;
    }

    public void setRevision(int revision) {
        this.semver.withIncPatch(-1 * this.semver.getPatch() + revision);
    }

    public String getSuffix() {
        return String.join((CharSequence)"", this.semver.getSuffixTokens());
    }

    public void setSuffix(String suffix) {
        this.semver.withSuffix(suffix);
    }
}

