/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.remote.coverage.server;



/**
 * Unique identifier for a configuration option. Every configuration option has a namespace and an identifier.
 * <p>
 * The namespace is a short name of the extension that defines the component. Even core configuration have a namespace even though
 * they have namespace in the declaration in the configuration files.
 *
* @author Mulesoft Inc.
 * @since 1.0
 */

public interface ComponentIdentifier {

  /**
   * The namespace is a short name of the extension that defines the component.
   *
   * @return the unique identifier namespace
   */
  String getNamespace();

  /**
   * @return the unique identifier configuration name
   */
  String getName();

  /**
   * @return builder to create an instance of {@link ComponentIdentifier}
   */
  static Builder builder() {
    return new DefaultComponentIdentifier.Builder();
  }

  /**
   * {@link ComponentIdentifier} builder interface.
   *
   * @since 1.0
   */

  interface Builder {

    /**
     * @param name name of the component
     * @return {@code this} builder
     */
    Builder name(String name);

    /**
     * @param namespace namespace owning the component
     * @return {@code this} builder
     */
    Builder namespace(String namespace);

    /**
     * @return a new instance of {@link ComponentIdentifier}
     */
    ComponentIdentifier build();

  }

}
