/*
 * Decompiled with CFR 0.152.
 */
package org.mule.maven.client.internal;

import java.io.File;
import java.util.function.Supplier;
import org.mule.maven.client.api.LocalRepositorySupplierFactory;

public class DefaultLocalRepositorySupplierFactory
implements LocalRepositorySupplierFactory {
    private static final String USER_HOME = "user.home";
    private static final String M2_REPO = "/.m2/repository";
    private static String userHome = System.getProperty("user.home");

    @Override
    public Supplier<File> fixedFolderSupplier(File folder) {
        return () -> folder;
    }

    @Override
    public Supplier<File> environmentMavenRepositorySupplier() {
        return () -> DefaultLocalRepositorySupplierFactory.getMavenLocalRepository();
    }

    @Override
    public Supplier<File> composeSuppliers(Supplier<File> ... suppliers) {
        return () -> {
            for (Supplier supplier : suppliers) {
                File file = (File)supplier.get();
                if (file == null) continue;
                return file;
            }
            return null;
        };
    }

    private static File getMavenLocalRepository() {
        File mavenLocalRepositoryLocation;
        String localRepositoryProperty = System.getProperty("localRepository");
        if (localRepositoryProperty == null) {
            localRepositoryProperty = userHome + M2_REPO;
        }
        if (!(mavenLocalRepositoryLocation = new File(localRepositoryProperty)).exists()) {
            throw new IllegalArgumentException("Maven repository location couldn't be found, please check your configuration");
        }
        return mavenLocalRepositoryLocation;
    }
}

