/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote.coverage.model;

import org.apache.commons.lang3.StringUtils;
import org.mule.munit.common.util.Preconditions;

public class MuleLocation {
    private String path;
    private Integer lineNumber;

    public MuleLocation(String path, Integer lineNumber) {
        Preconditions.checkArgument(StringUtils.isNoneEmpty(path), "The path must not be null nor empty.");
        Preconditions.checkNotNull(lineNumber, "The line number must not be null.");
        this.path = path;
        this.lineNumber = lineNumber;
    }

    public String getPath() {
        return this.path;
    }

    public Integer getLineNumber() {
        return this.lineNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MuleLocation)) {
            return false;
        }
        MuleLocation that = (MuleLocation)o;
        if (!this.path.equals(that.path)) {
            return false;
        }
        return this.lineNumber.equals(that.lineNumber);
    }

    public int hashCode() {
        int result = this.path.hashCode();
        result = 31 * result + this.lineNumber.hashCode();
        return result;
    }
}

