/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote.runtime.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.mule.munit.common.util.Preconditions;
import org.mule.munit.remote.runtime.utils.AbstractMuleArtifactModel;
import org.mule.munit.remote.runtime.utils.AbstractMuleArtifactModelBuilder;
import org.mule.munit.remote.runtime.utils.MuleArtifactLoaderDescriptor;
import org.mule.munit.remote.runtime.utils.Product;

public abstract class MuleDeployableModel
extends AbstractMuleArtifactModel {
    private Set<String> configs;
    private List<String> secureProperties;
    private Boolean redeploymentEnabled = true;
    private String logConfigFile;

    protected MuleDeployableModel(String name, String minMuleVersion, Product product, MuleArtifactLoaderDescriptor classLoaderModelLoaderDescriptor, MuleArtifactLoaderDescriptor bundleDescriptorLoader, Set<String> configs, Optional<Boolean> redeploymentEnabled, List<String> secureProperties, String logConfigFile) {
        super(name, minMuleVersion, product, classLoaderModelLoaderDescriptor, bundleDescriptorLoader);
        this.configs = configs;
        this.redeploymentEnabled = redeploymentEnabled.orElse(true);
        this.secureProperties = secureProperties;
        this.logConfigFile = logConfigFile;
    }

    public MuleDeployableModel() {
    }

    public Set<String> getConfigs() {
        return this.configs == null ? null : Collections.unmodifiableSet(this.configs);
    }

    public boolean isRedeploymentEnabled() {
        return this.redeploymentEnabled == null ? true : this.redeploymentEnabled;
    }

    public List<String> getSecureProperties() {
        return this.secureProperties;
    }

    public String getLogConfigFile() {
        return this.logConfigFile;
    }

    protected static abstract class MuleDeployableModelBuilder<T extends AbstractMuleArtifactModelBuilder, M extends MuleDeployableModel>
    extends AbstractMuleArtifactModelBuilder<T, M> {
        private Set<String> configs = new HashSet<String>();
        private Boolean redeploymentEnabled;
        private List<String> secureProperties = new ArrayList<String>();
        private String logConfigFile;

        protected MuleDeployableModelBuilder() {
        }

        public void setConfigs(Set<String> configs) {
            this.configs = configs;
        }

        @Override
        public final M build() {
            Preconditions.checkArgument(!StringUtils.isBlank(this.getName()), "name cannot be a blank");
            Preconditions.checkArgument(this.getMinMuleVersion() != null, "minMuleVersion cannot be null");
            Preconditions.checkArgument(this.getBundleDescriptorLoader() != null, "bundleDescriber cannot be null");
            return this.doCreateModel(this.configs, this.redeploymentEnabled, this.secureProperties, this.logConfigFile);
        }

        protected abstract M doCreateModel(Set<String> var1, Boolean var2, List<String> var3, String var4);

        public void setRedeploymentEnabled(boolean redeploymentEnabled) {
            this.redeploymentEnabled = redeploymentEnabled;
        }

        public void setSecureProperties(List<String> secureProperties) {
            this.secureProperties = secureProperties;
        }

        public void setLogConfigFile(String logConfigFile) {
            this.logConfigFile = logConfigFile;
        }
    }
}

