/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.common.protocol.notifiers;

import com.google.gson.Gson;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.mule.munit.common.protocol.listeners.RunEventListener;
import org.mule.munit.common.protocol.message.RunMessage;
import org.mule.munit.common.protocol.message.TestStatus;
import org.mule.munit.common.util.Collections;
import org.mule.munit.common.util.Preconditions;

public abstract class RunMessageNotifier
implements RunEventListener {
    protected String runToken;
    private Gson gson = new Gson();

    public abstract void init() throws Exception;

    public void setRunToken(String runToken) {
        this.runToken = runToken;
    }

    @Override
    public void notifyRunStart() {
        this.sendMessage(12, java.util.Collections.emptyMap());
    }

    @Override
    public void notifySuiteStart(String path, String parameterization, int numberOfTests) {
        this.sendMessage(1, Collections.mapOf("munitSuite", path, "parameterizationKey", this.nonNullValue(parameterization), "numberOfTests", String.valueOf(numberOfTests)));
    }

    @Override
    public void notifyContainerFailure(String stackTrace) {
        this.sendMessage(2, java.util.Collections.singletonMap("stackTrace", stackTrace));
    }

    @Override
    public void notifyContainerFailure(String suite, String parameterization, String stackTrace) {
        this.sendMessage(13, Collections.mapOf("munitSuite", suite, "parameterizationKey", this.nonNullValue(parameterization), "stackTrace", stackTrace));
    }

    @Override
    public void notifyBeforeSuiteStart(String name) {
        this.sendMessage(3, java.util.Collections.singletonMap("name", name));
    }

    @Override
    public void notifyBeforeSuiteEnd(String name, String stackTrace, TestStatus status) {
        this.sendMessage(4, Collections.mapOf("name", name, "stackTrace", stackTrace, "status", status.toString()));
    }

    @Override
    public void notifyTestStart(String name, String description, boolean isIgnored, String fileName) {
        this.sendMessage(5, Collections.mapOf("name", name, "description", description, "ignored", String.valueOf(isIgnored), "fileName", fileName));
    }

    @Override
    public void notifyTestEnd(String name, String stackTrace, TestStatus status, long elapsedTime, String fileName) {
        this.sendMessage(6, Collections.mapOf("name", name, "stackTrace", stackTrace, "elapsedTime", String.valueOf(elapsedTime), "status", status.toString(), "fileName", fileName));
    }

    @Override
    public void notifyAfterSuiteStart(String name) {
        this.sendMessage(7, java.util.Collections.singletonMap("name", name));
    }

    @Override
    public void notifyAfterSuiteEnd(String name, String stackTrace, TestStatus status) {
        this.sendMessage(8, Collections.mapOf("name", name, "stackTrace", stackTrace, "status", status.toString()));
    }

    @Override
    public void notifySuiteEnd(String suite, String parameterization, long elapsedTime) {
        this.sendMessage(9, Collections.mapOf("munitSuite", suite, "parameterizationKey", this.nonNullValue(parameterization), "elapsedTime", String.valueOf(elapsedTime)));
    }

    @Override
    public void notifyCoverageReport(String coverageReportJson) {
        this.sendMessage(10, java.util.Collections.singletonMap("coverageReport", coverageReportJson));
    }

    @Override
    public void notifyRunFinish() {
        this.sendMessage(11, java.util.Collections.emptyMap());
    }

    @Override
    public void notifyUnexpectedError(String stackTrace) {
        this.sendMessage(99, java.util.Collections.singletonMap("stackTrace", stackTrace));
    }

    @Override
    public void notifySuiteUnexpectedError(String name, String stackTrace) {
        this.sendMessage(98, Collections.mapOf("name", name, "stackTrace", stackTrace));
    }

    private void sendMessage(Integer id, Map<String, String> parameters) {
        Preconditions.checkArgument(StringUtils.isNotBlank(this.runToken), "runToken must not be null nor empty");
        HashMap<String, String> completeParams = new HashMap<String, String>();
        completeParams.put("runToken", this.runToken);
        completeParams.putAll(parameters);
        this.sendMessage(this.gson.toJson(new RunMessage(id, completeParams)));
    }

    private String nonNullValue(String value) {
        return value == null ? "" : value;
    }

    public abstract void sendMessage(String var1);
}

