/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.embedded.internal.utils;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;
import org.mule.maven.pom.parser.api.model.BundleDependency;
import org.mule.maven.pom.parser.api.model.BundleDescriptor;
import org.mule.maven.pom.parser.api.model.BundleScope;
import org.mule.runtime.module.embedded.api.Product;
import org.mule.runtime.module.embedded.api.dependencies.DependencyResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedImplementationUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmbeddedImplementationUtils.class);
    private static final String IGNORED_DEPENDENCIES_FILE_NAME = "ignored-dependencies.properties";

    private static URL getEmbeddedImplUrl(DependencyResolver dependencyResolver, String muleVersion) throws MalformedURLException {
        BundleDescriptor embeddedImplDescriptor = new BundleDescriptor.Builder().setGroupId("org.mule.distributions").setArtifactId("mule-module-embedded-impl").setVersion(muleVersion).setType("jar").build();
        return dependencyResolver.resolveBundleDescriptor(embeddedImplDescriptor).getBundleUri().toURL();
    }

    public static ClassLoader createEmbeddedImplClassLoader(ClassLoader parentClassLoader, DependencyResolver dependencyResolver, String muleVersion) throws MalformedURLException {
        BundleDescriptor embeddedBomDescriptor = new BundleDescriptor.Builder().setGroupId("org.mule.distributions").setArtifactId("mule-module-embedded-impl-bom").setVersion(muleVersion).setType("pom").build();
        List<BundleDependency> embeddedImplDependencies = dependencyResolver.resolveBundleDescriptorDependencies(embeddedBomDescriptor);
        List<URL> embeddedUrls = embeddedImplDependencies.stream().filter(bundleDependency -> !bundleDependency.getScope().equals((Object)BundleScope.PROVIDED)).map(dep -> {
            try {
                return dep.getBundleUri().toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
        embeddedUrls.add(EmbeddedImplementationUtils.getEmbeddedImplUrl(dependencyResolver, muleVersion));
        return new URLClassLoader(embeddedUrls.toArray(new URL[embeddedUrls.size()]), parentClassLoader);
    }

    public static List<Product.ArtifactCoordinates> getDependenciesToIgnoreForCurrentJavaVersion(DependencyResolver dependencyResolver, String muleVersion) {
        String currentJavaVersion = System.getProperty("java.specification.version");
        try {
            ArrayList<Product.ArtifactCoordinates> dependenciesToIgnore = new ArrayList<Product.ArtifactCoordinates>();
            EmbeddedImplementationUtils.getDependenciesToIgnore(dependencyResolver, muleVersion).forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(dependency, javaVersions) -> {
                Set javaVersionsSet = Arrays.stream(((String)javaVersions).split(",")).collect(Collectors.toSet());
                if (javaVersionsSet.stream().anyMatch(currentJavaVersion::equals)) {
                    String groupId = ((String)dependency).split(":")[0];
                    String artifactId = ((String)dependency).split(":")[1];
                    dependenciesToIgnore.add(new Product.ArtifactCoordinates(groupId, artifactId));
                }
            }));
            LOGGER.info("Dependencies to ignore for Runtime version {} and Java version {}: {}", muleVersion, currentJavaVersion, dependenciesToIgnore);
            return dependenciesToIgnore;
        }
        catch (Exception e) {
            LOGGER.debug("Couldn't retrieve dependencies to ignore for Runtime version {} and Java version {}", muleVersion, currentJavaVersion, e);
            Product.ArtifactCoordinates xmlApis = new Product.ArtifactCoordinates("xml-apis", "xml-apis");
            return SystemUtils.isJavaVersionAtLeast(JavaVersion.JAVA_17) ? Collections.singletonList(xmlApis) : Collections.emptyList();
        }
    }

    public static Properties getDependenciesToIgnore(DependencyResolver dependencyResolver, String muleVersion) throws Exception {
        try (URLClassLoader classLoader = new URLClassLoader(new URL[]{EmbeddedImplementationUtils.getEmbeddedImplUrl(dependencyResolver, muleVersion)});){
            Properties dependenciesToIgnoreProperties = new Properties();
            dependenciesToIgnoreProperties.load(classLoader.getResourceAsStream(IGNORED_DEPENDENCIES_FILE_NAME));
            Properties properties = dependenciesToIgnoreProperties;
            return properties;
        }
    }
}

