/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.remote.api.configuration;

import static java.nio.charset.StandardCharsets.UTF_8;

import com.google.gson.Gson;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.ParseException;

/**
 * Takes a Command Line Arguments and generates a runConfiguration
 *
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
public class RunConfigurationParser {

  public static final String RUN_CONFIGURATION_PARAMETER = "run_configuration";

  private static final int MIN_PORT_NUMBER = 50000;
  private static final int MAX_PORT_NUMBER = 55000;


  public RunConfigurationParser() {}

  public RunConfiguration parse(String[] args) throws ParseException, IOException {
    for (int i = 0; i < args.length; i++) {
      if (args[i].equals("-" + RUN_CONFIGURATION_PARAMETER)) {
        return buildRunConfiguration(args[i + 1]);
      }
    }
    throw new ParseException("run configuration not found", 0);
  }

  private RunConfiguration buildRunConfiguration(String file) throws IOException {
    Reader reader = new InputStreamReader(new FileInputStream(file), UTF_8);
    return new Gson().fromJson(reader, RunConfiguration.class);
  }
}
