/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.remote.coverage.server;

import java.util.Optional;
import java.util.OptionalInt;

/**
 * A location part represent an specific location of a component within another component.
 *
 * @author Mulesoft Inc.
 * @since 1.0
 */
public interface LocationPart {

  /**
   * @return the string representation of the part
   */
  String getPartPath();

  /**
   * A location part represent an specific location of a component within another component.
   *
   * @since 4.0
   */
  Optional<TypedComponentIdentifier> getPartIdentifier();

  /**
   * @return the config file of the application where this component is defined, if it was defined in a config file.
   */
  Optional<String> getFileName();

  /**
   * @return the line number in the config file of the application where this component is defined, if it was defined in a config
   *         file.
   *
   * @deprecated Use {@link #getLine()} instead.
   */
  @Deprecated
  Optional<Integer> getLineInFile();

  /**
   * @return the start column in the config file of the application where this component is defined, if it was defined in a config
   *         file.
   *
   * @deprecated Use {@link #getColumn()} instead.
   */
  @Deprecated
  Optional<Integer> getStartColumn();

  /**
   * @return the line number in the config file of the application where this component is defined, if it was defined in a config
   *         file.
   */
  OptionalInt getLine();

  /**
   * @return the start column in the config file of the application where this component is defined, if it was defined in a config
   *         file.
   */
  OptionalInt getColumn();

}
