/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.remote;

import org.mule.munit.remote.api.configuration.RunConfiguration;
import org.mule.munit.remote.container.ContainerSuiteRunDispatcher;
import org.mule.munit.remote.container.EmbeddedContainerFactory;
import org.mule.munit.remote.container.SuiteRunDispatcher;
import org.mule.munit.remote.container.SuiteRunLocator;
import org.mule.munit.remote.container.model.SuiteRun;

import java.io.File;
import java.util.Set;

/**
 * Creates a {@Link SuiteRunDispatcher} based on {@Link DeploymentType}
 *
 * @author Mulesoft Inc.
 * @since 2.3.0
 */
public class SuiteRunDispatcherFactory {

  private final RunConfiguration runConfiguration;
  private final EmbeddedContainerFactory embeddedContainerFactory;

  public SuiteRunDispatcherFactory(RunConfiguration runConfiguration, EmbeddedContainerFactory embeddedContainerFactory) {
    this.runConfiguration = runConfiguration;
    this.embeddedContainerFactory = embeddedContainerFactory;
  }

  public SuiteRunDispatcher create() {
    File appDir = new File(runConfiguration.getContainerConfiguration().getMunitWorkingDirectoryPath(),
                           runConfiguration.getProjectName());
    runConfiguration.getContainerConfiguration().getRuntimeId();
    Set<SuiteRun> suiteRuns = new SuiteRunLocator(runConfiguration, appDir).locate();
    return new ContainerSuiteRunDispatcher(embeddedContainerFactory.createContainer(runConfiguration), runConfiguration,
                                           suiteRuns, appDir, runConfiguration.getMmvs());
  }

}
