/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import org.apache.xerces.parsers.DOMParser;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.config.ConfigurationBuilder;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.modules.interceptor.connectors.ConnectorMethodInterceptorFactory;
import org.mule.munit.common.endpoint.MockEndpointManager;
import org.mule.munit.common.endpoint.MunitSpringFactoryPostProcessor;
import org.mule.munit.common.extensions.MunitPlugin;
import org.mule.munit.common.processor.interceptor.MunitMessageProcessorInterceptorFactory;
import org.mule.munit.runner.MunitLoggerConfigurer;
import org.mule.munit.runner.MunitMuleContextFactory;
import org.mule.munit.runner.MunitPluginFactory;
import org.mule.munit.runner.mule.context.MunitDomParser;
import org.mule.munit.runner.output.DefaultOutputHandler;
import org.mule.munit.runner.spring.config.MunitSpringXmlConfigurationBuilder;
import org.mule.munit.runner.spring.config.model.BeanDefinitionGenericBuilder;
import org.mule.munit.runner.spring.config.model.MockingConfiguration;

public class MuleContextManager {
    private Collection<MunitPlugin> plugins;
    private MockingConfiguration configuration;

    public MuleContextManager(MockingConfiguration configuration) {
        this.configuration = configuration;
    }

    public MuleContext startMule(String resources) throws Exception {
        MuleContext context = this.createMule(resources);
        return this.startMule(context);
    }

    public MuleContext startMule(MuleContext context) throws MuleException {
        context.start();
        this.startPlugins();
        return context;
    }

    public void killMule(MuleContext muleContext) {
        try {
            if (muleContext != null && !muleContext.isStopped()) {
                muleContext.stop();
                this.stopPlugins();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (muleContext != null && !muleContext.isDisposed()) {
            muleContext.dispose();
            this.disposePlugins();
        }
        this.clearLogginConfiguration();
    }

    public MuleContext createMule(String resources) throws Exception {
        this.defineLogOutput(resources);
        ConfigurationBuilder configurationBuilder = this.createConfigurationBuilder(resources);
        ArrayList<ConfigurationBuilder> builders = new ArrayList<ConfigurationBuilder>();
        builders.add(configurationBuilder);
        MunitMuleContextFactory contextCreator = new MunitMuleContextFactory(this.getStartUpProperties(), builders);
        MuleContext context = contextCreator.createMuleContext();
        this.plugins = new MunitPluginFactory().loadPlugins(context);
        this.initialisePlugins();
        return context;
    }

    protected ConfigurationBuilder createConfigurationBuilder(String resources) throws Exception {
        MunitSpringXmlConfigurationBuilder.ConfigurationBuilderBuilder builder = new MunitSpringXmlConfigurationBuilder.ConfigurationBuilderBuilder(resources);
        builder.withMockingConfiguration((BeanDefinitionGenericBuilder)this.configuration).withMunitFactoryPostProcessor("___MunitSpringFactoryPostProcessor", MunitSpringFactoryPostProcessor.class).withEndpointFactoryClass(MockEndpointManager.class).withBeanToRegister("__messageProcessorEnhancerFactory", MunitMessageProcessorInterceptorFactory.class).withBeanToRegister(ConnectorMethodInterceptorFactory.ID, ConnectorMethodInterceptorFactory.class).withMunitDomParser((DOMParser)new MunitDomParser());
        MunitSpringXmlConfigurationBuilder configuratioBuilder = builder.build();
        return configuratioBuilder;
    }

    private void clearLogginConfiguration() {
        MunitMuleContextFactory.clearLoggingConfiguration();
    }

    private Properties getStartUpProperties() {
        Properties properties;
        Properties properties2 = properties = this.configuration == null ? null : this.configuration.getStartUpProperties();
        if (properties == null) {
            properties = new Properties();
        }
        if (properties.get("app.home") == null) {
            properties.setProperty("app.home", new File(this.getClass().getResource("/").getPath()).getAbsolutePath());
        }
        return properties;
    }

    private void defineLogOutput(String resources) throws IOException {
        String path = System.getProperty(DefaultOutputHandler.OUTPUT_FOLDER_PROPERTY);
        if (path != null) {
            String name = resources.replace(".xml", "");
            MunitLoggerConfigurer.configureFileLogger(path, name);
        }
    }

    private void startPlugins() throws MuleException {
        for (MunitPlugin plugin : this.plugins) {
            plugin.start();
        }
    }

    private void disposePlugins() {
        for (MunitPlugin plugin : this.plugins) {
            plugin.dispose();
        }
    }

    private void stopPlugins() throws MuleException {
        for (MunitPlugin plugin : this.plugins) {
            plugin.stop();
        }
    }

    private void initialisePlugins() throws InitialisationException {
        for (MunitPlugin plugin : this.plugins) {
            plugin.initialise();
        }
    }
}

