/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.runner.output;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


/**
 * <p>Prints the output in a log file</p>
 *
 * @author Mulesoft Inc.
 * @since 3.3.2
 */
public class LogPrinter implements OutputPrinter
{

    private Log log;

    public LogPrinter()
    {
        this.log = LogFactory.getLog(LogPrinter.class);

    }

    @Override
    public void print(String message)
    {
        log.info(message);
    }
}
