/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.runner.spring.config.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

/**
 * <p>
 * The configuration of the mocking elements for Munit
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 3.3.2
 */
public class MockingConfiguration implements BeanDefinitionGenericBuilder {
    public static final String MOCK_INBOUNDS_PROPERTY_NAME = "mockInbounds";
    public static final String MOCK_CONNECTORS_PROPERTY_NAME = "mockConnectors";
    public static final String MOCKING_EXCLUDED_FLOWS_PROPERTY_NAME = "mockingExcludedFlows";

    private boolean mockInbounds;
    private List<String> mockingExcludedFlows;
    private boolean mockConnectors;
    private Properties startUpProperties;

    public MockingConfiguration(boolean mockInbounds, List<String> mockingExcludedFlows, boolean mockConnectors, Properties startUpProperties) {
        this.mockInbounds = mockInbounds;
        this.mockingExcludedFlows = mockingExcludedFlows;
        this.mockConnectors = mockConnectors;
        this.startUpProperties = startUpProperties;
    }

    public List<String> getMockingExcludedFlows() {
        return mockingExcludedFlows;
    }

    public boolean isMockInbounds() {
        return mockInbounds;
    }

    public boolean isMockConnectors() {
        return mockConnectors;
    }

    public Properties getStartUpProperties() {
        return startUpProperties;
    }

    public Map<String, Object> buildAttributeMap() {
        Map<String, Object> propertyMap = new HashMap<String, Object>();

        propertyMap.put(MOCK_INBOUNDS_PROPERTY_NAME, this.isMockInbounds());
        propertyMap.put(MOCK_CONNECTORS_PROPERTY_NAME, this.isMockConnectors());
        propertyMap.put(MOCKING_EXCLUDED_FLOWS_PROPERTY_NAME, this.getMockingExcludedFlows());

        return propertyMap;
    }
}
