/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.remote;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.mule.munit.runner.mule.MunitSuiteRunner;
import org.mule.munit.runner.mule.MunitTest;
import org.mule.munit.runner.mule.result.notification.Notification;
import org.mule.munit.runner.remote.RemoteRunnerNotificationListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MunitRemoteRunner {
    public static final String PORT_PARAMETER = "-port";
    public static final String TEST_PATH_PARAMETER = "-path";
    public static final String RESOURCE_PARAMETER = "-resource";
    public static final String TEST_NAME_PARAMETER = "-test_name";
    public static final String TEST_NAME_TOKEN_SEPARATOR = "<";
    protected String message;
    protected Socket requestSocket;
    protected ObjectOutputStream out;

    public static void main(String[] args) {
        int port = -1;
        String path = null;
        String resource = null;
        String testName = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase(RESOURCE_PARAMETER)) {
                resource = args[i + 1];
            }
            if (args[i].equalsIgnoreCase(PORT_PARAMETER)) {
                port = Integer.valueOf(args[i + 1]);
            }
            if (args[i].equalsIgnoreCase(TEST_PATH_PARAMETER)) {
                path = args[i + 1];
            }
            if (!args[i].equalsIgnoreCase(TEST_NAME_PARAMETER)) continue;
            testName = args[i + 1];
        }
        MunitRemoteRunner serverRemoteRunner = new MunitRemoteRunner();
        serverRemoteRunner.run(port, path, resource, testName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(int port, String path, String resources, String testName) {
        RemoteRunnerNotificationListener listener = null;
        try {
            MunitSuiteRunner runner;
            this.requestSocket = new Socket("localhost", port);
            System.out.println("[" + this.getClass().getName() + "]" + "Connected to localhost in port " + port);
            this.out = new ObjectOutputStream(this.requestSocket.getOutputStream());
            this.out.flush();
            listener = new RemoteRunnerNotificationListener(this.out);
            List<String> testNameList = this.buildTestNamesList(testName);
            try {
                runner = new MunitSuiteRunner(resources, testNameList);
                runner.setNotificationListener(listener);
            }
            catch (RuntimeException e) {
                listener.notifyRuntimeStartFailure(new Notification(e.getMessage(), MunitTest.stack2string(e)));
                throw e;
            }
            listener.notifyNumberOfTest(runner.getNumberOfTests());
            runner.run();
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
        }
        finally {
            if (listener != null) {
                listener.notifyTestRunEnd(path);
            }
            try {
                if (null != this.out) {
                    this.out.close();
                }
                if (null != this.requestSocket) {
                    this.requestSocket.close();
                }
            }
            catch (IOException ioException) {
                ioException.printStackTrace();
            }
            System.out.println("[" + this.getClass().getName() + "]" + "Done");
        }
        System.exit(0);
    }

    private List<String> buildTestNamesList(String testNames) {
        List<Object> testNameList = StringUtils.isNotBlank((String)testNames) ? Arrays.asList(testNames.split(TEST_NAME_TOKEN_SEPARATOR)) : new ArrayList();
        return testNameList;
    }
}

