/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.parsers.DOMParser;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.config.ConfigurationBuilder;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.modules.interceptor.connectors.ConnectorMethodInterceptorFactory;
import org.mule.munit.common.endpoint.MockEndpointManager;
import org.mule.munit.common.endpoint.MunitSpringFactoryPostProcessor;
import org.mule.munit.common.extensions.MunitPlugin;
import org.mule.munit.common.processor.interceptor.MunitMessageProcessorInterceptorFactory;
import org.mule.munit.runner.MunitLoggerConfigurer;
import org.mule.munit.runner.MunitMuleContextFactory;
import org.mule.munit.runner.MunitPluginFactory;
import org.mule.munit.runner.exception.ExceptionStrategyReplacer;
import org.mule.munit.runner.mule.context.MunitDomParser;
import org.mule.munit.runner.output.DefaultOutputHandler;
import org.mule.munit.runner.properties.ApplicationPropertyLoader;
import org.mule.munit.runner.properties.MUnitUserPropertiesManager;
import org.mule.munit.runner.spring.config.MunitSpringXmlConfigurationBuilder;
import org.mule.munit.runner.spring.config.model.BeanDefinitionGenericBuilder;
import org.mule.munit.runner.spring.config.model.MockingConfiguration;
import org.mule.munit.runner.spring.config.reader.MunitHandlerWrapper;
import org.mule.util.ClassUtils;

public class MuleContextManager {
    private transient Log logger = LogFactory.getLog(this.getClass());
    private Collection<MunitPlugin> plugins;
    private MockingConfiguration configuration;
    private static final Integer CONSTRUCTOR_ARG_LIMIT = 13;

    public MuleContextManager(MockingConfiguration configuration) {
        this.configuration = configuration;
    }

    public MuleContext startMule(String resources) throws Exception {
        MuleContext context = this.createMule(resources);
        return this.startMule(context);
    }

    public MuleContext startMule(MuleContext context) throws MuleException {
        this.logger.debug((Object)"Starting Mule Context tuned by MUnit...");
        context.start();
        this.startPlugins();
        this.logger.debug((Object)"Mule Context tuned by MUnit Started");
        return context;
    }

    public void killMule(MuleContext muleContext) {
        this.logger.debug((Object)"Stopping Mule Context tuned by MUnit...");
        try {
            if (muleContext != null && !muleContext.isStopped()) {
                muleContext.stop();
                this.stopPlugins();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (muleContext != null && !muleContext.isDisposed()) {
            muleContext.dispose();
            this.disposePlugins();
        }
        this.logger.debug((Object)"Mule Context stopped");
        this.clearLogginConfiguration();
    }

    public MuleContext createMule(String resources) throws Exception {
        this.logger.debug((Object)"Creating Mule Context tuned by MUnit...");
        this.defineLogOutput(resources);
        this.defineBeanConstructorArgLimit();
        this.loadMuleAppProperties();
        ConfigurationBuilder configurationBuilder = this.createConfigurationBuilder(resources);
        ArrayList<ConfigurationBuilder> builders = new ArrayList<ConfigurationBuilder>();
        builders.add(configurationBuilder);
        MunitMuleContextFactory contextCreator = new MunitMuleContextFactory(this.getStartUpProperties(), builders);
        MuleContext context = contextCreator.createMuleContext();
        this.replaceExceptionStrategies(context);
        this.plugins = new MunitPluginFactory().loadPlugins(context);
        this.initialisePlugins();
        return context;
    }

    protected void defineBeanConstructorArgLimit() {
        try {
            Method method = MunitHandlerWrapper.class.getDeclaredMethod("setConstructorArgLimit", Integer.class);
            if (null != method) {
                method.invoke(null, CONSTRUCTOR_ARG_LIMIT);
            }
        }
        catch (NoSuchMethodException e) {
            this.logger.debug((Object)"Using MUnit Support that doesn't support constructor parameter definition");
        }
        catch (InvocationTargetException e) {
            this.logger.debug((Object)"Fail to set constructor arg limit in MUnit support");
        }
        catch (IllegalAccessException e) {
            this.logger.debug((Object)"Fail to set constructor arg limit in MUnit support");
        }
    }

    protected ConfigurationBuilder createConfigurationBuilder(String resources) throws Exception {
        this.logger.debug((Object)("Creating ConfigurationBuilder for resources: " + resources));
        MunitSpringXmlConfigurationBuilder.ConfigurationBuilderBuilder builder = new MunitSpringXmlConfigurationBuilder.ConfigurationBuilderBuilder(resources);
        builder.withMockingConfiguration((BeanDefinitionGenericBuilder)this.configuration).withMunitFactoryPostProcessor("___MunitSpringFactoryPostProcessor", MunitSpringFactoryPostProcessor.class).withEndpointFactoryClass(MockEndpointManager.class).withBeanToRegister("__messageProcessorEnhancerFactory", MunitMessageProcessorInterceptorFactory.class).withBeanToRegister(ConnectorMethodInterceptorFactory.ID, ConnectorMethodInterceptorFactory.class).withBeanToRegister("__exceptionStrategyReplacer", ExceptionStrategyReplacer.class).withMunitDomParser((DOMParser)new MunitDomParser());
        MunitSpringXmlConfigurationBuilder configuratioBuilder = builder.build();
        return configuratioBuilder;
    }

    private void replaceExceptionStrategies(MuleContext context) {
        this.logger.debug((Object)"Replacing exception strategies with MUnit proxies...");
        ExceptionStrategyReplacer replacer = (ExceptionStrategyReplacer)context.getRegistry().get("__exceptionStrategyReplacer");
        replacer.setMuleContext(context);
        replacer.replace();
    }

    private void clearLogginConfiguration() {
        MunitMuleContextFactory.clearLoggingConfiguration();
    }

    private Properties getStartUpProperties() {
        Properties properties;
        this.logger.debug((Object)"Loading startup properties...");
        Properties properties2 = properties = this.configuration == null ? null : this.configuration.getStartUpProperties();
        if (properties == null) {
            properties = new Properties();
        }
        if (properties.get("app.home") == null) {
            properties.setProperty("app.home", new File(this.getClass().getResource("/").getPath()).getAbsolutePath());
        }
        this.logger.debug((Object)("Startup properties loaded: [" + properties.toString() + "]"));
        return properties;
    }

    private void defineLogOutput(String resources) throws IOException {
        String path = System.getProperty(DefaultOutputHandler.OUTPUT_FOLDER_PROPERTY);
        if (path != null) {
            String name = resources.replace(".xml", "");
            MunitLoggerConfigurer.configureFileLogger(path, name);
        }
    }

    private void startPlugins() throws MuleException {
        this.logger.debug((Object)"Starting MUnit plugins...");
        for (MunitPlugin plugin : this.plugins) {
            plugin.start();
            this.logger.debug((Object)(plugin.getClass().getName() + " plugin started"));
        }
    }

    private void disposePlugins() {
        this.logger.debug((Object)"Disposing MUnit plugins...");
        for (MunitPlugin plugin : this.plugins) {
            plugin.dispose();
            this.logger.debug((Object)(plugin.getClass().getName() + " plugin disposed"));
        }
    }

    private void stopPlugins() throws MuleException {
        for (MunitPlugin plugin : this.plugins) {
            plugin.stop();
        }
    }

    private void initialisePlugins() throws InitialisationException {
        this.logger.debug((Object)"Initializing MUnit plugins...");
        for (MunitPlugin plugin : this.plugins) {
            plugin.initialise();
            this.logger.debug((Object)(plugin.getClass().getName() + " plugin initialised"));
        }
    }

    private void loadMuleAppProperties() {
        this.logger.info((Object)"Loading application properties...");
        ApplicationPropertyLoader propertyLoader = new ApplicationPropertyLoader(new MUnitUserPropertiesManager(), this.logger);
        URL url = ClassUtils.getResource((String)"mule-app.properties", this.getClass());
        propertyLoader.loadAndSetApplicationProperties(url);
        this.logger.debug((Object)"Application properties loading [DONE]");
    }
}

