/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.runner.exception;

import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.exception.MessagingExceptionHandler;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Lifecycle;
import org.mule.munit.common.exception.MunitError;
import org.mule.util.ExceptionUtils;

/**
 * The purpose of this class is to by pass Assertion Errors.
 * <p/>
 * Assertion Errors can be thrown by assert MPs during a Spy.
 * In these scenarios, the flow should not wrap that error and just let it pass so the tests invoking the flow can fail.
 *
 * @since 1.1.0
 */
public class MunitMessagingExceptionHandler implements MessagingExceptionHandler, Lifecycle {
    private MessagingExceptionHandler originalMessagingExceptionHandler;

    public MunitMessagingExceptionHandler(MessagingExceptionHandler originalHandler) {
        this.originalMessagingExceptionHandler = originalHandler;
    }

    @Override
    public MuleEvent handleException(Exception exception, MuleEvent event) {
        Throwable rootCause = ExceptionUtils.getRootCause(exception);
        if (null != rootCause) {

            if (AssertionError.class.isAssignableFrom(rootCause.getClass())) {
                throw (Error) ExceptionUtils.getRootCause(exception);
            }

            if (MunitError.class.isAssignableFrom(rootCause.getClass())) {
                throw (Error) ExceptionUtils.getRootCause(exception);
            }
        }

        return originalMessagingExceptionHandler.handleException(exception, event);
    }

    @Override
    public void dispose() {
        ((Lifecycle) originalMessagingExceptionHandler).dispose();
    }

    @Override
    public void initialise() throws InitialisationException {
        ((Lifecycle) originalMessagingExceptionHandler).initialise();
    }

    @Override
    public void start() throws MuleException {
        ((Lifecycle) originalMessagingExceptionHandler).start();
    }

    @Override
    public void stop() throws MuleException {
        ((Lifecycle) originalMessagingExceptionHandler).stop();
    }
}
