/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.runner.remote;

import org.apache.commons.lang.Validate;

/**
 * This is the message that we sent out to Studio in order to notify the status of the run.
 */
@Deprecated
public class RemoteRunnerMessage {
    public static final String FIELD_TOKEN = new String(new byte[]{0x1b});

    private String messageId;
    private String runToken;
    private String suitePath;
    private String suiteName;
    private String testName;
    private String freeMessage;
    private String stackTrace;
    private String jsonMessage;

    public RemoteRunnerMessage(String messageId, String runToken) {
        Validate.notEmpty(messageId, "The Remote runner message id must not be null nor empty");
        Validate.notEmpty(runToken, "The run token");
        this.messageId = messageId;
        this.runToken = runToken;
    }

    public void setSuitePath(String suitePath) {
        this.suitePath = suitePath;
    }

    public void setSuiteName(String suiteName) {
        this.suiteName = suiteName;
    }

    public void setTestName(String testName) {
        this.testName = testName;
    }

    public void setFreeMessage(String freeMessage) {
        this.freeMessage = freeMessage;
    }

    public void setStackTrace(String stackTrace) {
        this.stackTrace = stackTrace;
    }

    public void setJsonMessage(String jsonMessage) {
        this.jsonMessage = jsonMessage;
    }

    public String build() {
        StringBuilder builder = new StringBuilder();

        builder.append(messageId)
                .append(FIELD_TOKEN)
                .append(runToken)
                .append(FIELD_TOKEN)
                .append(suitePath)
                .append(FIELD_TOKEN)
                .append(suiteName)
                .append(FIELD_TOKEN)
                .append(testName)
                .append(FIELD_TOKEN)
                .append(freeMessage)
                .append(FIELD_TOKEN)
                .append(stackTrace)
                .append(FIELD_TOKEN)
                .append(jsonMessage);

        return builder.toString();
    }
}
