/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.domain;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.munit.runner.domain.DomainContextBuilder;
import org.mule.munit.runner.domain.MuleDeployPropertyLoader;

public class MunitDomainContextBuilder {
    private transient Log logger = LogFactory.getLog(this.getClass());
    private static final String DOMAIN_CONFIG_FILE_NAME = "mule-domain-config.xml";
    private final String projectName;
    private DomainContextBuilder domainContextBuilder;
    private MuleDeployPropertyLoader muleDeployPropertyLoader;

    public MunitDomainContextBuilder(String projectName) {
        this.projectName = projectName;
        this.domainContextBuilder = new DomainContextBuilder();
        this.muleDeployPropertyLoader = new MuleDeployPropertyLoader(projectName);
    }

    public MuleContext buildDomainContextIfRequired() throws Exception {
        MuleContext domainContext = null;
        if (StringUtils.isBlank((String)this.projectName)) {
            this.logger.debug((Object)"No project name provided Domain Context won't be built");
            return domainContext;
        }
        String domainResources = this.loadDomainResources();
        if (StringUtils.isNotBlank((String)domainResources)) {
            this.logger.debug((Object)("About to build Domain Context with resources: " + domainResources));
            domainContext = this.domainContextBuilder.setDomainConfig(domainResources).build();
            this.logger.debug((Object)"Domain Context built");
        } else {
            this.logger.debug((Object)"No domain resources found, Domain Context won't be built");
        }
        return domainContext;
    }

    private String loadDomainResources() {
        String domainResources = "";
        this.logger.info((Object)"Loading mule-deploy.properties ...");
        String domainName = this.muleDeployPropertyLoader.getApplicationDeployProperties().get("domain");
        if (StringUtils.isNotBlank((String)domainName) && !"default".equals(domainName.toLowerCase())) {
            domainName = domainName.toLowerCase();
            this.logger.debug((Object)("Domain found: " + domainName));
            domainResources = DOMAIN_CONFIG_FILE_NAME;
        } else {
            this.logger.debug((Object)"No domain or default domain found.");
        }
        return domainResources;
    }

    public void setDomainContextBuilder(DomainContextBuilder domainContextBuilder) {
        this.domainContextBuilder = domainContextBuilder;
    }

    public void setMuleDeployPropertyLoader(MuleDeployPropertyLoader muleDeployPropertyLoader) {
        this.muleDeployPropertyLoader = muleDeployPropertyLoader;
    }
}

