/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.mule;

import java.util.List;
import org.mule.api.MuleContext;
import org.mule.munit.runner.MuleContextManager;
import org.mule.munit.runner.MunitRunner;
import org.mule.munit.runner.mule.MunitSuite;
import org.mule.munit.runner.mule.MunitSuiteBuilder;
import org.mule.munit.runner.mule.result.SuiteResult;
import org.mule.munit.runner.mule.result.notification.NotificationListener;
import org.mule.munit.runner.output.DefaultOutputHandler;
import org.mule.munit.runner.output.TestOutputHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MunitSuiteRunner {
    private MuleContext muleContext;
    private MunitSuite suite;
    private TestOutputHandler handler = new DefaultOutputHandler();
    private MuleContextManager muleContextManager = new MuleContextManager(null);

    public MunitSuiteRunner(String resources, List<String> testNameList, String projectName) {
        try {
            this.muleContext = this.muleContextManager.startMule(resources, projectName);
            this.suite = (MunitSuite)new MunitSuiteBuilder(this.muleContext, this.handler).build(resources, testNameList);
        }
        catch (Exception e) {
            this.muleContextManager.killMule(this.muleContext);
            throw new RuntimeException(e);
        }
    }

    public SuiteResult run() {
        return (SuiteResult)new MunitRunner<SuiteResult>(this.handler, this.muleContextManager, this.muleContext){

            @Override
            protected SuiteResult runSuite() throws Exception {
                return MunitSuiteRunner.this.suite.run();
            }

            @Override
            protected String getSuiteName() {
                return MunitSuiteRunner.this.suite.getName();
            }
        }.run();
    }

    public void setNotificationListener(NotificationListener notificationListener) {
        this.suite.setNotificationListener(notificationListener);
    }

    public int getNumberOfTests() {
        return this.suite.getNumberOfTests();
    }

    public void setHandler(TestOutputHandler handler) {
        this.handler = handler;
    }
}

