/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.runner.exception;

import org.mule.api.MuleContext;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.exception.MessagingExceptionHandler;
import org.mule.construct.AbstractFlowConstruct;
import org.mule.exception.DefaultMessagingExceptionStrategy;
import org.mule.munit.assertion.processors.MunitTestFlow;

import java.util.Collection;

/**
 * The purpose of this class is to  replace all the MessagingExceptionHandler from all the flows in the application.
 *
 * @since 1.1.0
 */
public class ExceptionStrategyReplacer {

    public static final String ID = "__exceptionStrategyReplacer";

    private MuleContext context;

    public void replace() {
        if (null == context) {
            throw new IllegalStateException("The bean " + ID + " has not been correctly initialized. MuleContext missing.");
        }

        Collection<FlowConstruct> flows = context.getRegistry().lookupFlowConstructs();
        for (FlowConstruct flow : flows) {
            MessagingExceptionHandler originalHandler = flow.getExceptionListener();
            if (!MunitTestFlow.class.isAssignableFrom(flow.getClass())) {
                if (null != originalHandler) {
                    MunitMessagingExceptionHandler munitHandler = new MunitMessagingExceptionHandler(originalHandler);
                    ((AbstractFlowConstruct) flow).setExceptionListener(munitHandler);
                }
            } else {
                if (null != originalHandler && !(originalHandler instanceof DefaultMessagingExceptionStrategy)) {
                    MunitMessagingExceptionHandler munitHandler = new MunitMessagingExceptionHandler(originalHandler);
                    ((AbstractFlowConstruct) flow).setExceptionListener(munitHandler);
                }
            }


        }
    }


    public void setMuleContext(MuleContext muleContext) {
        this.context = muleContext;
    }

}
