/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.runner.remote;


import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.mule.munit.runner.mule.MunitSuiteRunner;
import org.mule.munit.runner.mule.MunitTest;
import org.mule.munit.runner.mule.result.notification.Notification;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Deprecated
public class MunitRemoteRunner {
    public static final String PORT_PARAMETER = "-port";
    public static final String RESOURCE_PARAMETER = "-resource";
    public static final String RUN_TOKEN_PARAMETER = "-run_token";
    public static final String TEST_NAME_PARAMETER = "-test_name";

    public static final String RESOURCES_TOKEN_SEPARATOR = ",";

    public static final String TEST_NAME_TOKEN_SEPARATOR = "<";

    public static final String CALCULATE_APPLICATION_PATHS_SYSTEM_PROPERTY = "calculate.application.paths";

    protected String message;
    protected Socket requestSocket;
    protected ObjectOutputStream out;

    public static void main(String args[]) {
        int port = -1;

        String runToken = null;
        String resources = null;
        String testName = null;

        for (int i = 0; i < args.length; i++) {
            if (args[i].equalsIgnoreCase(RUN_TOKEN_PARAMETER)) {
                runToken = args[i + 1];
            }

            if (args[i].equalsIgnoreCase(RESOURCE_PARAMETER)) {
                resources = args[i + 1];
            }
            if (args[i].equalsIgnoreCase(PORT_PARAMETER)) {
                port = Integer.valueOf(args[i + 1]);
            }

            if (args[i].equalsIgnoreCase(TEST_NAME_PARAMETER)) {
                testName = args[i + 1];
            }
        }

        MunitRemoteRunner serverRemoteRunner = new MunitRemoteRunner();
        serverRemoteRunner.run(port, runToken, resources, testName);

    }

    /**
     * This method's goal is to run a single test suite file and notify events to a listening server.
     *
     * @param port      the port to connect to notify run status
     * @param runToken  the token to id this specific run
     * @param resources a comma separated list of resource files path to be loaded
     * @param testName  the test name, if any, in the event you wish to run a single test. It's a regex.
     */
    public void run(int port, String runToken, String resources, String testName) {
        RemoteRunnerNotificationListener listener = null;
        try {
            connectToStudioServer(port);
            listener = new RemoteRunnerNotificationListener(runToken, out);

            listener.notifyRunStart();

            List<String> testNameList = buildTestNamesList(testName);
            for (String resource : resources.split(RESOURCES_TOKEN_SEPARATOR)) {
                runTestSuite(resource, testNameList, listener);
            }

        } catch (IOException ioException) {
            // this only can happen if connection can't be established
            ioException.printStackTrace();
        } finally {
            if (null != listener) {
                listener.notifyRunFinish();
            }

            closeConnectionToStudioServer();

            System.out.println("[" + this.getClass().getName() + "]" + "Done");
        }
        System.exit(0);
    }

    private List<String> buildTestNamesList(String testNames) {
        List<String> testNameList;
        if (StringUtils.isNotBlank(testNames)) {
            testNameList = Arrays.asList(testNames.split(TEST_NAME_TOKEN_SEPARATOR));
        } else {
            testNameList = new ArrayList();
        }
        return testNameList;
    }

    private void connectToStudioServer(int port) throws IOException {
        requestSocket = new Socket("localhost", port);
        System.out.println("[" + this.getClass().getName() + "]" + "Connected to localhost in port " + port);
        out = new ObjectOutputStream(requestSocket.getOutputStream());
        out.flush();
    }

    private void closeConnectionToStudioServer() {
        try {
            if (null != out) {
                out.close();
            }
            if (null != requestSocket) {
                requestSocket.close();
            }
        } catch (IOException ioException) {
            ioException.printStackTrace();
        }
    }

    private int runTestSuite(String resource, List<String> testNames, RemoteRunnerNotificationListener listener) {
        String suitePath = FilenameUtils.getPath(resource);
        String suiteName = FilenameUtils.getName(resource);

        String projectName = System.getProperty("munitProjectName");

        listener.defineCurrentSuite(suitePath, suiteName);
        MunitSuiteRunner runner;
        try {
            runner = new MunitSuiteRunner(resource, testNames,projectName);
            runner.setNotificationListener(listener);
            listener.notifySuiteStart();
            listener.notifyNumberOfTest(runner.getNumberOfTests());
        } catch (RuntimeException e) {
            listener.notifySuiteStartFailure(new Notification(e.getMessage(), MunitTest.stack2string(e)));
            throw e;
        }

        try {
            runner.run();
        } finally {
            listener.notifySuiteFinished();
            return runner.getNumberOfTests();
        }
    }
}
