/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.runner.mule.result.notification;

import org.mule.munit.runner.mule.MunitTest;
import org.mule.munit.runner.mule.result.SuiteResult;
import org.mule.munit.runner.mule.result.TestResult;

import java.util.ArrayList;
import java.util.List;

public class SuiteRunnerEventListenerContainer implements SuiteRunnerEventListener {

    private List<SuiteRunnerEventListener> suiteRunnerEventListeners = new ArrayList<SuiteRunnerEventListener>();


    public void notifySuiteStart(String path) {
        for (SuiteRunnerEventListener suiteRunnerEventListener : suiteRunnerEventListeners) {
            suiteRunnerEventListener.notifySuiteStart(path);
        }
    }

    @Override
    public void notifyTestStart(MunitTest test) {
        for (SuiteRunnerEventListener suiteRunnerEventListener : suiteRunnerEventListeners) {
            suiteRunnerEventListener.notifyTestStart(test);
        }
    }

    public void notifyNumberOfTests(int numberOfTests) {
        for (SuiteRunnerEventListener suiteRunnerEventListener : suiteRunnerEventListeners) {
            suiteRunnerEventListener.notifyNumberOfTests(numberOfTests);
        }
    }

    @Override
    public void notifyTestResult(TestResult testResult) {
        for (SuiteRunnerEventListener suiteRunnerEventListener : suiteRunnerEventListeners) {
            suiteRunnerEventListener.notifyTestResult(testResult);
        }
    }

    @Override
    public void notifyTestIgnored(TestResult testResult) {
        for (SuiteRunnerEventListener suiteRunnerEventListener : suiteRunnerEventListeners) {
            suiteRunnerEventListener.notifyTestIgnored(testResult);
        }
    }

    @Override
    public void notifySuiteEnd(SuiteResult result) {
        for (SuiteRunnerEventListener suiteRunnerEventListener : suiteRunnerEventListeners) {
            suiteRunnerEventListener.notifySuiteEnd(result);
        }
    }

    public void notifySuiteStartFailure(Notification notification) {
        for (SuiteRunnerEventListener suiteRunnerEventListener : suiteRunnerEventListeners) {
            suiteRunnerEventListener.notifySuiteStartFailure(notification);
        }

    }

    public void notifyBeforeSuiteFailure(Notification notification) {
        for (SuiteRunnerEventListener suiteRunnerEventListener : suiteRunnerEventListeners) {
            suiteRunnerEventListener.notifyBeforeSuiteFailure(notification);
        }
    }

    public void notifyBeforeSuiteError(Notification notification) {
        for (SuiteRunnerEventListener suiteRunnerEventListener : suiteRunnerEventListeners) {
            suiteRunnerEventListener.notifyBeforeSuiteError(notification);
        }
    }

    public void notifyAfterSuiteFailure(Notification notification) {
        for (SuiteRunnerEventListener suiteRunnerEventListener : suiteRunnerEventListeners) {
            suiteRunnerEventListener.notifyAfterSuiteFailure(notification);
        }
    }

    public void notifyAfterSuiteError(Notification notification) {
        for (SuiteRunnerEventListener suiteRunnerEventListener : suiteRunnerEventListeners) {
            suiteRunnerEventListener.notifyAfterSuiteError(notification);
        }
    }

    public void addNotificationListener(SuiteRunnerEventListener listener) {
        suiteRunnerEventListeners.add(listener);
    }
}
