/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.properties;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.mule.munit.runner.properties.MUnitUserPropertiesManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationPropertyLoader {
    public static final String DEFAULT_APP_PROPERTIES_RESOURCE = "mule-app.properties";
    private Log log;
    private MUnitUserPropertiesManager propertiesManager;

    public ApplicationPropertyLoader(MUnitUserPropertiesManager propertiesManager, Log log) {
        this.log = log;
        this.propertiesManager = propertiesManager;
    }

    public void loadAndSetApplicationProperties(URL resourceUrl) {
        if (resourceUrl == null) {
            this.log.warn((Object)"mule-app.properties file was not found");
            return;
        }
        try {
            Map<String, String> appPropsMap = this.loadApplicationProperties(resourceUrl);
            this.setApplicationProperties(appPropsMap);
        }
        catch (IOException e) {
            this.log.warn((Object)"mule-app.properties could not be loaded.");
        }
    }

    private Map<String, String> loadApplicationProperties(URL appPropsFile) throws IOException {
        HashMap<String, String> appPropsMap = new HashMap<String, String>();
        Properties props = this.loadPropertiesFromFile(appPropsFile);
        for (Object key : props.keySet()) {
            appPropsMap.put(key.toString(), props.getProperty(key.toString()));
        }
        return appPropsMap;
    }

    private void setApplicationProperties(Map<String, String> properties) {
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            if (MUnitUserPropertiesManager.hasSystemProperty(entry.getKey())) continue;
            if (MUnitUserPropertiesManager.hasEnvironmentProperty(entry.getKey())) continue;
            this.propertiesManager.addApplicationProperty(entry.getKey(), entry.getValue());
            this.log.debug((Object)("System property [" + entry.getKey() + "] set to: [" + entry.getValue() + "]"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadPropertiesFromFile(URL url) throws IOException {
        Properties props;
        if (url == null) {
            throw new IOException("Invalid file URL!");
        }
        InputStream is = url.openStream();
        try {
            props = new Properties();
            props.load(is);
        }
        finally {
            is.close();
        }
        return props;
    }
}

