/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.properties;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MUnitUserPropertiesManager {
    private static Properties initialSystemProperties;
    private static Set<String> notAllowedPropertyKeys;
    private Map<String, String> applicationProperties = new ConcurrentHashMap<String, String>();

    public static void storeInitialSystemProperties() {
        initialSystemProperties = (Properties)System.getProperties().clone();
    }

    public static void restoreInitialSystemProperties() {
        System.setProperties(initialSystemProperties);
    }

    public MUnitUserPropertiesManager() {
        MUnitUserPropertiesManager.storeInitialSystemProperties();
    }

    public static void addUserPropertiesToSystem(Map<String, String> userProperties) {
        if (userProperties != null) {
            for (Map.Entry<String, String> entry : userProperties.entrySet()) {
                MUnitUserPropertiesManager.addUserPropertyToSystem(entry.getKey(), entry.getValue());
            }
        }
    }

    public static void addUserPropertyToSystem(String key, String value) {
        Validate.notBlank((CharSequence)key, (String)"The property key must not be null nor empty", (Object[])new Object[0]);
        if (MUnitUserPropertiesManager.isPropertyKeyAllowed(key).booleanValue()) {
            System.setProperty(key, value);
        }
    }

    public void addApplicationProperty(String key, String value) {
        Validate.notBlank((CharSequence)key, (String)"The property key must not be null nor empty", (Object[])new Object[0]);
        if (MUnitUserPropertiesManager.isPropertyKeyAllowed(key).booleanValue()) {
            this.applicationProperties.put(key, value);
            System.setProperty(key, value);
        }
    }

    public Map<String, String> getApplicationProperties() {
        HashMap<String, String> appProp = new HashMap<String, String>();
        appProp.putAll(this.applicationProperties);
        return appProp;
    }

    public static boolean hasSystemProperty(String key) {
        return System.getProperty(key) != null;
    }

    public static boolean hasEnvironmentProperty(String key) {
        return System.getenv(key) != null;
    }

    private static Boolean isPropertyKeyAllowed(String key) {
        return !notAllowedPropertyKeys.contains(key);
    }

    private static Set<String> defineNotAllowedPropertyKeys() {
        HashSet<String> propertyKeysSet = new HashSet<String>();
        propertyKeysSet.add("java.library.path");
        propertyKeysSet.add("file.encoding");
        propertyKeysSet.add("jdk.map.althashing.threshold");
        return propertyKeysSet;
    }

    static {
        notAllowedPropertyKeys = MUnitUserPropertiesManager.defineNotAllowedPropertyKeys();
    }
}

