/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.java;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.junit.runner.Describable;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.manipulation.Sortable;
import org.junit.runner.manipulation.Sorter;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.mule.api.MuleContext;
import org.mule.munit.runner.MuleContextManager;
import org.mule.munit.runner.MunitRunner;
import org.mule.munit.runner.java.JunitTestSuiteBuilder;
import org.mule.munit.runner.output.DefaultOutputHandler;
import org.mule.munit.runner.output.TestOutputHandler;

public class MuleSuiteRunner
extends Runner
implements Filterable,
Sortable {
    private TestSuite testSuite;
    private MuleContext muleContext;
    private MuleContextManager muleContextManager = new MuleContextManager(null);

    public MuleSuiteRunner(Class testClass) {
        try {
            Method getConfigResources = testClass.getMethod("getConfigResources", new Class[0]);
            String resources = (String)getConfigResources.invoke(testClass.newInstance(), new Object[0]);
            this.muleContext = this.muleContextManager.startMule(resources, "");
            this.testSuite = (TestSuite)new JunitTestSuiteBuilder(this.muleContext).build(testClass.getSimpleName());
        }
        catch (Exception e) {
            this.muleContextManager.killMule(this.muleContext);
            throw new RuntimeException(e);
        }
    }

    public Description getDescription() {
        return MuleSuiteRunner.makeDescription((Test)this.testSuite);
    }

    public TestListener createAdaptingListener(RunNotifier notifier) {
        return new OldTestClassAdaptingListener(notifier);
    }

    public void run(RunNotifier notifier) {
        final TestResult result = new TestResult();
        result.addListener(this.createAdaptingListener(notifier));
        new MunitRunner<Void>((TestOutputHandler)new DefaultOutputHandler(), this.muleContextManager, this.muleContext){

            @Override
            protected Void runSuite() throws Exception {
                MuleSuiteRunner.this.testSuite.run(result);
                return null;
            }

            @Override
            protected String getSuiteName() {
                return MuleSuiteRunner.this.testSuite.getName();
            }
        }.run();
    }

    private static Description makeDescription(Test test) {
        if (test instanceof TestSuite) {
            TestSuite ts = (TestSuite)test;
            String name = ts.getName() == null ? MuleSuiteRunner.createSuiteDescription(ts) : ts.getName();
            Description description = Description.createSuiteDescription((String)name, (Annotation[])new Annotation[0]);
            int n = ts.testCount();
            for (int i = 0; i < n; ++i) {
                Description made = MuleSuiteRunner.makeDescription(ts.testAt(i));
                description.addChild(made);
            }
            return description;
        }
        TestCase mt = (TestCase)test;
        return Description.createTestDescription(mt.getClass(), (String)mt.getName());
    }

    private static String createSuiteDescription(TestSuite ts) {
        int count = ts.countTestCases();
        String example = count == 0 ? "" : String.format(" [example: %s]", ts.testAt(0));
        return String.format("TestSuite with %s tests%s", count, example);
    }

    public void filter(Filter filter) throws NoTestsRemainException {
        TestSuite filtered = new TestSuite(this.testSuite.getName());
        int n = this.testSuite.testCount();
        for (int i = 0; i < n; ++i) {
            Test test = this.testSuite.testAt(i);
            if (!filter.shouldRun(MuleSuiteRunner.makeDescription(test))) continue;
            filtered.addTest(test);
        }
        this.testSuite = filtered;
    }

    public void sort(Sorter sorter) {
        if (this.testSuite instanceof Sortable) {
            Sortable adapter = (Sortable)this.testSuite;
            adapter.sort(sorter);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class OldTestClassAdaptingListener
    implements TestListener {
        private final RunNotifier fNotifier;

        private OldTestClassAdaptingListener(RunNotifier notifier) {
            this.fNotifier = notifier;
        }

        public void endTest(Test test) {
            this.fNotifier.fireTestFinished(this.asDescription(test));
        }

        public void startTest(Test test) {
            this.fNotifier.fireTestStarted(this.asDescription(test));
        }

        public void addError(Test test, Throwable t) {
            Failure failure = new Failure(this.asDescription(test), t);
            this.fNotifier.fireTestFailure(failure);
        }

        private Description asDescription(Test test) {
            if (test instanceof Describable) {
                Describable facade = (Describable)test;
                return facade.getDescription();
            }
            return Description.createTestDescription(this.getEffectiveClass(test), (String)this.getName(test));
        }

        private Class<? extends Test> getEffectiveClass(Test test) {
            return test.getClass();
        }

        private String getName(Test test) {
            if (test instanceof TestCase) {
                return ((TestCase)test).getName();
            }
            return test.toString();
        }

        public void addFailure(Test test, AssertionFailedError t) {
            this.addError(test, (Throwable)t);
        }
    }
}

