/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.mule;

import java.util.ArrayList;
import java.util.List;
import org.mule.munit.runner.mule.MunitTest;
import org.mule.munit.runner.mule.result.SuiteResult;
import org.mule.munit.runner.mule.result.TestResult;
import org.mule.munit.runner.mule.result.notification.DummySuiteRunnerEventListener;
import org.mule.munit.runner.mule.result.notification.SuiteRunnerEventListener;

public class MunitSuite {
    private String name;
    private List<MunitTest> munitTests = new ArrayList<MunitTest>();
    private SuiteRunnerEventListener suiteRunnerEventListener = new DummySuiteRunnerEventListener();

    public MunitSuite(String name) {
        this.name = name;
    }

    public void add(MunitTest test) {
        this.munitTests.add(test);
    }

    public SuiteResult run() throws Exception {
        SuiteResult result = new SuiteResult(this.name);
        this.suiteRunnerEventListener.notifyNumberOfTests(this.getNumberOfTests());
        for (MunitTest test : this.munitTests) {
            this.suiteRunnerEventListener.notifyTestStart(test);
            TestResult testResult = test.run();
            result.add(testResult);
            if (testResult.isSkipped()) {
                this.suiteRunnerEventListener.notifyTestIgnored(testResult);
            }
            this.suiteRunnerEventListener.notifyTestResult(testResult);
        }
        return result;
    }

    public void setSuiteRunnerEventListener(SuiteRunnerEventListener suiteRunnerEventListener) {
        if (suiteRunnerEventListener == null) {
            throw new IllegalArgumentException();
        }
        this.suiteRunnerEventListener = suiteRunnerEventListener;
    }

    public int getNumberOfTests() {
        return this.munitTests.size();
    }

    public String getName() {
        return this.name;
    }
}

