/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.runner.mule;

import org.mule.api.MuleContext;
import org.mule.munit.assertion.processors.MunitFlow;
import org.mule.munit.assertion.processors.MunitTestFlow;
import org.mule.munit.runner.SuiteBuilder;
import org.mule.munit.runner.output.TestOutputHandler;

import java.util.List;


/**
 * <p>Creates a Munit Suite and its tests</p>
 *
 * @author Mulesoft Inc.
 * @since 3.3.2
 */
public class MunitSuiteBuilder extends SuiteBuilder<MunitSuite, MunitTest>
{

    private TestOutputHandler handler;


    public MunitSuiteBuilder(MuleContext muleContext,
                             TestOutputHandler handler)
    {
        super(muleContext);

        if (handler == null)
        {
            throw new IllegalArgumentException("Handler must not be null");
        }

        this.handler = handler;
    }

    /**
     * @see SuiteBuilder
     */
    @Override
    protected MunitSuite createSuite(String name)
    {
        MunitSuite suite = new MunitSuite(name);
        for (MunitTest test : this.tests)
        {
            suite.add(test);
        }

        return suite;
    }

    /**
     * @see SuiteBuilder
     */
    @Override
    protected MunitTest test(List<MunitFlow> beforeTest, MunitTestFlow test, List<MunitFlow> afterTest)
    {
        return new MunitTest(beforeTest, test, afterTest, handler, muleContext);
    }
}
