/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.runner.simple;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.munit.runner.MuleContextManager;
import org.mule.munit.runner.spring.config.model.MockingConfiguration;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * The Goal of this class is to start a Mule context with a simple MUnit configuration.
 * This configuration will not mock any endpoint nor will it add any other feature.
 * <p/>
 * Each of the MunitSimpleRunnerAction provided will be run after the context is started in the order provided by the list.
 */
public class MunitSimpleRunner {
    private transient Log log = LogFactory.getLog(this.getClass());

    private String resources;
    private List<MunitSimpleRunnerAction> actions;
    private String projectName;

    public MunitSimpleRunner(String resources, List<MunitSimpleRunnerAction> actions, String projectName) {
        this.resources = resources;
        this.actions = actions;
        this.projectName = projectName;
    }

    /**
     * Starts a Mule Context and run each of the actions provided.
     */
    public void run() {
        log.debug("Counting application flow paths: " + new Date().toString());

        MuleContext muleContext = null;
        MuleContextManager muleContextManager = new MuleContextManager(createConfiguration());
        try {
            muleContext = muleContextManager.createMule(resources,projectName);

            for (MunitSimpleRunnerAction action : actions) {
                action.execute(muleContext);
            }

        } catch (Exception e) {
            throw new RuntimeException(e);
        } finally {
            if (null != muleContext) {
                muleContextManager.killMule(muleContext);
            }
            log.debug("Application flow paths count done: " + new Date().toString());
        }
    }


    public String getResources() {
        return resources;
    }

    private MockingConfiguration createConfiguration() {
        return new MockingConfiguration(false, new ArrayList<String>(), false, null);
    }

}
