/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.parsers.DOMParser;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.config.ConfigurationBuilder;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.registry.RegistrationException;
import org.mule.modules.interceptor.connectors.ConnectorMethodInterceptorFactory;
import org.mule.munit.common.endpoint.MockEndpointManager;
import org.mule.munit.common.endpoint.MunitSpringFactoryPostProcessor;
import org.mule.munit.common.extensions.MunitPlugin;
import org.mule.munit.common.processor.interceptor.MunitMessageProcessorInterceptorFactory;
import org.mule.munit.runner.MunitMuleContextFactory;
import org.mule.munit.runner.MunitPluginFactory;
import org.mule.munit.runner.domain.MunitDomainContextBuilder;
import org.mule.munit.runner.exception.ExceptionStrategyReplacer;
import org.mule.munit.runner.mule.context.MunitDomParser;
import org.mule.munit.runner.properties.ApplicationPropertyLoader;
import org.mule.munit.runner.properties.MUnitUserPropertiesManager;
import org.mule.munit.runner.spring.config.MunitSpringXmlConfigurationBuilder;
import org.mule.munit.runner.spring.config.model.BeanDefinitionGenericBuilder;
import org.mule.munit.runner.spring.config.model.MockingConfiguration;
import org.mule.munit.runner.spring.config.reader.MunitHandlerWrapper;
import org.mule.util.ClassUtils;

public class MuleContextManager {
    private static final Integer CONSTRUCTOR_ARG_LIMIT = 13;
    public static final String USE_XALAN_TRANSFORMER_PROPERTY = "useXalanTransformer";
    private transient Log logger = LogFactory.getLog(this.getClass());
    private MUnitUserPropertiesManager propertiesManager = new MUnitUserPropertiesManager();
    private Collection<MunitPlugin> plugins;
    private MockingConfiguration configuration;
    private Map<MuleContext, MuleContext> appDomainMap = new HashMap<MuleContext, MuleContext>();

    public MuleContextManager(MockingConfiguration configuration) {
        this.configuration = configuration;
    }

    public MuleContext startMule(String resources, String projectName) throws Exception {
        MuleContext context = this.createMule(resources, projectName);
        return this.startMule(context);
    }

    public MuleContext startMule(MuleContext context) throws MuleException {
        this.logger.debug((Object)"Starting Mule Context tuned by MUnit...");
        context.start();
        this.startPlugins();
        this.logger.debug((Object)"Mule Context tuned by MUnit Started");
        return context;
    }

    public void killMule(MuleContext muleContext) {
        this.logger.debug((Object)"Shooting down Mule Context tuned by MUnit...");
        this.stopMuleContext(muleContext);
        this.disposeMuleContext(muleContext);
        this.logger.debug((Object)"Mule Context shot down");
        this.clearLogginConfiguration();
    }

    public MuleContext createMule(String resources, String projectName) throws Exception {
        this.logger.debug((Object)"Creating Mule Context tuned by MUnit...");
        this.defineBeanConstructorArgLimit();
        this.loadMuleAppProperties();
        this.loadAdditionalSystemProperties();
        ConfigurationBuilder configurationBuilder = this.createConfigurationBuilder(resources, projectName);
        MuleContext domainContext = new MunitDomainContextBuilder(projectName).buildDomainContextIfRequired();
        if (null != domainContext) {
            ((MunitSpringXmlConfigurationBuilder)configurationBuilder).setDomainContext(domainContext);
        }
        ArrayList<ConfigurationBuilder> builders = new ArrayList<ConfigurationBuilder>();
        builders.add(configurationBuilder);
        MunitMuleContextFactory contextCreator = new MunitMuleContextFactory(this.getStartUpProperties(), builders);
        MuleContext context = contextCreator.createMuleContext();
        this.loadApplicationPropertiesToMuleContext(context);
        this.appDomainMap.put(context, domainContext);
        this.replaceExceptionStrategies(context);
        this.plugins = new MunitPluginFactory().loadPlugins(context);
        this.initialisePlugins();
        return context;
    }

    protected void defineBeanConstructorArgLimit() {
        try {
            Method method = MunitHandlerWrapper.class.getDeclaredMethod("setConstructorArgLimit", Integer.class);
            if (null != method) {
                method.invoke(null, CONSTRUCTOR_ARG_LIMIT);
            }
        }
        catch (NoSuchMethodException e) {
            this.logger.debug((Object)"Using MUnit Support that doesn't support constructor parameter definition");
        }
        catch (InvocationTargetException e) {
            this.logger.debug((Object)"Fail to set constructor arg limit in MUnit support");
        }
        catch (IllegalAccessException e) {
            this.logger.debug((Object)"Fail to set constructor arg limit in MUnit support");
        }
    }

    protected ConfigurationBuilder createConfigurationBuilder(String resources, String projectName) throws Exception {
        this.logger.debug((Object)("Creating ConfigurationBuilder for resources: " + resources));
        MunitSpringXmlConfigurationBuilder.ConfigurationBuilderBuilder builder = new MunitSpringXmlConfigurationBuilder.ConfigurationBuilderBuilder(resources);
        builder.withMockingConfiguration((BeanDefinitionGenericBuilder)this.configuration).withMunitFactoryPostProcessor("___MunitSpringFactoryPostProcessor", MunitSpringFactoryPostProcessor.class).withEndpointFactoryClass(MockEndpointManager.class).withBeanToRegister("__messageProcessorEnhancerFactory", MunitMessageProcessorInterceptorFactory.class).withBeanToRegister(ConnectorMethodInterceptorFactory.ID, ConnectorMethodInterceptorFactory.class).withBeanToRegister("__exceptionStrategyReplacer", ExceptionStrategyReplacer.class).withMunitDomParser((DOMParser)new MunitDomParser());
        MunitSpringXmlConfigurationBuilder configurationBuilder = builder.build();
        return configurationBuilder;
    }

    private void replaceExceptionStrategies(MuleContext context) {
        this.logger.debug((Object)"Replacing exception strategies with MUnit proxies...");
        ExceptionStrategyReplacer replacer = (ExceptionStrategyReplacer)context.getRegistry().get("__exceptionStrategyReplacer");
        replacer.setMuleContext(context);
        replacer.replace();
    }

    private void clearLogginConfiguration() {
        MunitMuleContextFactory.clearLoggingConfiguration();
    }

    private Properties getStartUpProperties() {
        Properties properties;
        this.logger.debug((Object)"Loading startup properties...");
        Properties properties2 = properties = this.configuration == null ? null : this.configuration.getStartUpProperties();
        if (properties == null) {
            properties = new Properties();
        }
        try {
            Object homeProperty = properties.get("app.home");
            if (homeProperty == null || StringUtils.isBlank((CharSequence)homeProperty.toString())) {
                String appHomePath = URLDecoder.decode(new File(this.getClass().getResource("/").getPath()).getParentFile().getAbsolutePath(), "UTF-8");
                properties.setProperty("app.home", appHomePath);
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        this.logger.debug((Object)("Startup properties loaded: [" + properties.toString() + "]"));
        return properties;
    }

    private void startPlugins() throws MuleException {
        this.logger.debug((Object)"Starting MUnit plugins...");
        for (MunitPlugin plugin : this.plugins) {
            plugin.start();
            this.logger.debug((Object)(plugin.getClass().getName() + " plugin started"));
        }
    }

    private void disposePlugins() {
        this.logger.debug((Object)"Disposing MUnit plugins...");
        for (MunitPlugin plugin : this.plugins) {
            plugin.dispose();
            this.logger.debug((Object)(plugin.getClass().getName() + " plugin disposed"));
        }
    }

    private void stopPlugins() throws MuleException {
        for (MunitPlugin plugin : this.plugins) {
            plugin.stop();
        }
    }

    private void initialisePlugins() throws InitialisationException {
        this.logger.debug((Object)"Initializing MUnit plugins...");
        for (MunitPlugin plugin : this.plugins) {
            plugin.initialise();
            this.logger.debug((Object)(plugin.getClass().getName() + " plugin initialised"));
        }
    }

    private void loadMuleAppProperties() {
        this.logger.info((Object)"Loading mule-app.properties ...");
        ApplicationPropertyLoader propertyLoader = new ApplicationPropertyLoader(this.propertiesManager, this.logger);
        URL url = ClassUtils.getResource((String)"mule-app.properties", this.getClass());
        propertyLoader.loadAndSetApplicationProperties(url);
        this.logger.debug((Object)"mule-app.properties loading done");
    }

    private void loadApplicationPropertiesToMuleContext(MuleContext context) {
        this.logger.info((Object)"Loading application properties to Mule Context");
        HashMap<String, String> appProp = new HashMap<String, String>();
        for (Map.Entry<String, String> e : this.propertiesManager.getApplicationProperties().entrySet()) {
            appProp.put(e.getKey(), e.getValue());
        }
        try {
            context.getRegistry().registerObjects(appProp);
        }
        catch (RegistrationException e) {
            this.logger.warn((Object)"There has been an error loading the application properties to the Mule Context", (Throwable)e);
        }
        this.logger.debug((Object)"Loading application properties to Mule Context done");
    }

    private void loadAdditionalSystemProperties() {
        if ("true".equals(System.getProperty(USE_XALAN_TRANSFORMER_PROPERTY))) {
            System.setProperty("javax.xml.transform.TransformerFactory", "org.apache.xalan.processor.TransformerFactoryImpl");
        }
    }

    private void stopMuleContext(MuleContext muleContext) {
        this.logger.debug((Object)"Stopping Mule Context tuned by MUnit...");
        try {
            if (muleContext != null && !muleContext.isStopped()) {
                muleContext.stop();
                this.stopPlugins();
                if (null != this.appDomainMap.get(muleContext) && !this.appDomainMap.get(muleContext).isStopped()) {
                    this.logger.debug((Object)"Stopping Mule Domain Context tuned...");
                    this.appDomainMap.get(muleContext).stop();
                    this.logger.debug((Object)"Mule Domain Context tuned stopped");
                }
            }
        }
        catch (Throwable e) {
            this.logger.debug((Object)"There has been an error while stopping Mule Context", e);
        }
        this.logger.debug((Object)"Mule Context stopped");
    }

    private void disposeMuleContext(MuleContext muleContext) {
        if (muleContext != null && !muleContext.isDisposed()) {
            this.logger.debug((Object)"Disposing Mule Context tuned by MUnit...");
            muleContext.dispose();
            this.disposePlugins();
            if (null != this.appDomainMap.get(muleContext) && !this.appDomainMap.get(muleContext).isDisposed()) {
                this.logger.debug((Object)"Disposing Mule Domain Context tuned...");
                this.appDomainMap.get(muleContext).dispose();
                this.logger.debug((Object)"Mule Domain Context tuned disposed");
            }
            this.logger.debug((Object)"Mule Context tuned by MUnit disposed");
        }
    }
}

