/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.runner.config;

import org.mule.munit.common.model.*;
import org.mule.munit.runner.processors.*;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.exception.MessagingExceptionHandler;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.core.internal.construct.DefaultFlowBuilder;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinition;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinitionProvider;

import java.util.LinkedList;
import java.util.List;

import static org.mule.munit.runner.config.MunitXmlNamespaceInfoProvider.NAME_SPACE;
import static org.mule.runtime.dsl.api.component.AttributeDefinition.Builder.*;
import static org.mule.runtime.dsl.api.component.TypeDefinition.fromType;

public class MunitComponentBuildingDefinitionProvider implements ComponentBuildingDefinitionProvider {

  private static final String CONFIG = "config";
  private static final String TEST = "test";
  private static final String BEFORE_TEST = "before-test";
  private static final String AFTER_TEST = "after-test";
  private static final String BEFORE_SUITE = "before-suite";
  private static final String AFTER_SUITE = "after-suite";

  private static final String SET_EVENT = "set-event";
  private static final String SET_NULL_PAYLOAD = "set-null-payload";

  private static ComponentBuildingDefinition.Builder baseDefinition =
      new ComponentBuildingDefinition.Builder().withNamespace(NAME_SPACE);

  @Override
  public void init() {}

  @Override
  public List<ComponentBuildingDefinition> getComponentBuildingDefinitions() {
    LinkedList<ComponentBuildingDefinition> componentBuildingDefinitions = new LinkedList<>();


    componentBuildingDefinitions.add(
                                     baseDefinition.copy()
                                         .withIdentifier(CONFIG)
                                         .withTypeDefinition(fromType(MunitModule.class))
                                         .withSetterParameterDefinition("name",
                                                                        fromSimpleParameter(MunitModule.MUNIT_MODULE_ID).build())
                                         .withSetterParameterDefinition("disableFlowSources",
                                                                        fromSimpleParameter("disableFlowSources").build())
                                         .withSetterParameterDefinition("excludeFlowSources",
                                                                        fromChildConfiguration(ExcludeFlowSources.class)
                                                                            .withIdentifier("exclude-flow-sources").build())
                                         .build());

    componentBuildingDefinitions
        .add(baseDefinition.copy().withIdentifier("exclude-flow-sources").withTypeDefinition(fromType(ExcludeFlowSources.class))
            .withSetterParameterDefinition("flows", fromChildConfiguration(List.class).withIdentifier("flows").build())
            .build());
    componentBuildingDefinitions
        .add(baseDefinition.copy().withIdentifier("flows").withTypeDefinition(fromType(List.class)).build());
    componentBuildingDefinitions.add(
                                     baseDefinition.copy().withIdentifier("flow").withTypeDefinition(fromType(String.class))
                                         .build());


    componentBuildingDefinitions.add(
                                     baseDefinition.copy()
                                         .withIdentifier(TEST)
                                         .withTypeDefinition(fromType(MunitTestFlow.class))
                                         .withConstructorParameterDefinition(fromSimpleParameter("name").build())
                                         .withConstructorParameterDefinition(fromReferenceObject(MuleContext.class).build())
                                         .withSetterParameterDefinition("ignore", fromSimpleParameter("ignore").build())
                                         .withSetterParameterDefinition("description", fromSimpleParameter("description").build())
                                         .withSetterParameterDefinition("expectedErrorType",
                                                                        fromSimpleParameter("expectedErrorType").build())
                                         .withSetterParameterDefinition("expectedException",
                                                                        fromSimpleParameter("expectedException").build())
                                         .withSetterParameterDefinition("tags", fromSimpleParameter("tags").build())
                                         .withSetterParameterDefinition("behavior",
                                                                        fromChildConfiguration(DefaultFlowBuilder.DefaultFlow.class)
                                                                            .withIdentifier("behavior")
                                                                            .build())
                                         .withSetterParameterDefinition("execution",
                                                                        fromChildConfiguration(DefaultFlowBuilder.DefaultFlow.class)
                                                                            .withIdentifier("execution")
                                                                            .build())
                                         .withSetterParameterDefinition("validation",
                                                                        fromChildConfiguration(DefaultFlowBuilder.DefaultFlow.class)
                                                                            .withIdentifier("validation")
                                                                            .build())
                                         .build());

    componentBuildingDefinitions.add(
                                     baseDefinition.copy()
                                         .withIdentifier(BEFORE_SUITE)
                                         .withTypeDefinition(fromType(MunitBeforeSuite.class))
                                         .withConstructorParameterDefinition(fromSimpleParameter("name").build())
                                         .withConstructorParameterDefinition(fromReferenceObject(MuleContext.class).build())
                                         .withSetterParameterDefinition("description", fromSimpleParameter("description").build())
                                         .withSetterParameterDefinition("messageProcessors",
                                                                        fromChildCollectionConfiguration(Processor.class).build())
                                         .build());

    componentBuildingDefinitions.add(
                                     baseDefinition.copy()
                                         .withIdentifier(BEFORE_TEST)
                                         .withTypeDefinition(fromType(MunitBeforeTest.class))
                                         .withConstructorParameterDefinition(fromSimpleParameter("name").build())
                                         .withConstructorParameterDefinition(fromReferenceObject(MuleContext.class).build())
                                         .withSetterParameterDefinition("description", fromSimpleParameter("description").build())
                                         .withSetterParameterDefinition("messageProcessors",
                                                                        fromChildCollectionConfiguration(Processor.class).build())
                                         .build());

    componentBuildingDefinitions.add(
                                     baseDefinition.copy()
                                         .withIdentifier(AFTER_TEST)
                                         .withTypeDefinition(fromType(MunitAfterTest.class))
                                         .withConstructorParameterDefinition(fromSimpleParameter("name").build())
                                         .withConstructorParameterDefinition(fromReferenceObject(MuleContext.class).build())
                                         .withSetterParameterDefinition("description", fromSimpleParameter("description").build())
                                         .withSetterParameterDefinition("messageProcessors",
                                                                        fromChildCollectionConfiguration(Processor.class).build())
                                         .build());

    componentBuildingDefinitions.add(
                                     baseDefinition.copy()
                                         .withIdentifier(AFTER_SUITE)
                                         .withTypeDefinition(fromType(MunitAfterSuite.class))
                                         .withConstructorParameterDefinition(fromSimpleParameter("name").build())
                                         .withConstructorParameterDefinition(fromReferenceObject(MuleContext.class).build())
                                         .withSetterParameterDefinition("description", fromSimpleParameter("description").build())
                                         .withSetterParameterDefinition("messageProcessors",
                                                                        fromChildCollectionConfiguration(Processor.class).build())
                                         .build());


    componentBuildingDefinitions.add(
                                     baseDefinition.copy()
                                         .withIdentifier(SET_NULL_PAYLOAD)
                                         .asPrototype()
                                         .withTypeDefinition(fromType(SetEventProcessor.class))
                                         .withSetterParameterDefinition("payload", fromSimpleParameter("payload").build())
                                         .build());

    componentBuildingDefinitions.add(
                                     baseDefinition.copy()
                                         .withIdentifier(SET_EVENT)
                                         .asPrototype()
                                         .withTypeDefinition(fromType(SetEventProcessor.class))
                                         .withSetterParameterDefinition("cloneOriginalEvent",
                                                                        fromSimpleParameter("cloneOriginalEvent").build())
                                         .withSetterParameterDefinition("payload",
                                                                        fromChildConfiguration(Payload.class)
                                                                            .withIdentifier("payload").build())
                                         .withSetterParameterDefinition("attributes",
                                                                        fromChildConfiguration(EventAttributes.class)
                                                                            .withIdentifier("attributes").build())
                                         .withSetterParameterDefinition("error",
                                                                        fromChildConfiguration(UntypedEventError.class)
                                                                            .withIdentifier("error").build())
                                         .withSetterParameterDefinition("variables",
                                                                        fromChildConfiguration(List.class)
                                                                            .withIdentifier("variables").build())
                                         .withSetterParameterDefinition("inboundProperties",
                                                                        fromChildConfiguration(List.class)
                                                                            .withIdentifier("inbound-properties").build())
                                         .withSetterParameterDefinition("sessionProperties",
                                                                        fromChildConfiguration(List.class)
                                                                            .withIdentifier("session-properties").build())
                                         .withSetterParameterDefinition("outboundProperties",
                                                                        fromChildConfiguration(List.class)
                                                                            .withIdentifier("outbound-properties").build())
                                         .withSetterParameterDefinition("inboundAttachments",
                                                                        fromChildConfiguration(List.class)
                                                                            .withIdentifier("inbound-attachments").build())
                                         .withSetterParameterDefinition("outboundAttachments",
                                                                        fromChildConfiguration(List.class)
                                                                            .withIdentifier("outbound-attachments").build())
                                         .build());

    componentBuildingDefinitions.add(
                                     baseDefinition.copy()
                                         .withIdentifier("payload")
                                         .withTypeDefinition(fromType(Payload.class))
                                         .withSetterParameterDefinition("value", fromSimpleParameter("value").build())
                                         .withSetterParameterDefinition("mediaType", fromSimpleParameter("mediaType").build())
                                         .withSetterParameterDefinition("encoding", fromSimpleParameter("encoding").build())
                                         .build());

    componentBuildingDefinitions.add(
                                     baseDefinition.copy()
                                         .withIdentifier("attributes")
                                         .withTypeDefinition(fromType(EventAttributes.class))
                                         .withSetterParameterDefinition("value", fromSimpleParameter("value").build())
                                         .build());

    componentBuildingDefinitions.add(
                                     baseDefinition.copy()
                                         .withIdentifier("error")
                                         .withTypeDefinition(fromType(UntypedEventError.class))
                                         .withSetterParameterDefinition("typeId", fromSimpleParameter("id").build())
                                         .withSetterParameterDefinition("cause", fromSimpleParameter("exception").build())
                                         .build());

    componentBuildingDefinitions
        .add(baseDefinition.copy().withIdentifier("variables").withTypeDefinition(fromType(List.class)).build());
    componentBuildingDefinitions
        .add(baseDefinition.copy().withIdentifier("inbound-properties").withTypeDefinition(fromType(List.class)).build());
    componentBuildingDefinitions
        .add(baseDefinition.copy().withIdentifier("session-properties").withTypeDefinition(fromType(List.class)).build());
    componentBuildingDefinitions
        .add(baseDefinition.copy().withIdentifier("outbound-properties").withTypeDefinition(fromType(List.class)).build());
    componentBuildingDefinitions
        .add(baseDefinition.copy().withIdentifier("inbound-attachments").withTypeDefinition(fromType(List.class)).build());
    componentBuildingDefinitions
        .add(baseDefinition.copy().withIdentifier("outbound-attachments").withTypeDefinition(fromType(List.class)).build());

    componentBuildingDefinitions.add(buildGenericPropertyDefinition("variable", Variable.class));
    componentBuildingDefinitions.add(buildGenericPropertyDefinition("inbound-property", Property.class));
    componentBuildingDefinitions.add(buildGenericPropertyDefinition("session-property", Property.class));
    componentBuildingDefinitions.add(buildGenericPropertyDefinition("outbound-property", Property.class));
    componentBuildingDefinitions.add(buildGenericPropertyDefinition("inbound-attachment", Attachment.class));
    componentBuildingDefinitions.add(buildGenericPropertyDefinition("outbound-attachment", Attachment.class));


    componentBuildingDefinitions.add(buildDefaultFlowDefinition("behavior"));
    componentBuildingDefinitions.add(buildDefaultFlowDefinition("execution"));
    componentBuildingDefinitions.add(buildDefaultFlowDefinition("validation"));

    return componentBuildingDefinitions;
  }

  private ComponentBuildingDefinition buildGenericPropertyDefinition(String identifier, Class clazz) {
    return baseDefinition.copy()
        .withIdentifier(identifier)
        .withTypeDefinition(fromType(clazz))
        .withSetterParameterDefinition("key", fromSimpleParameter("key").build())
        .withSetterParameterDefinition("value", fromSimpleParameter("value").build())
        .withSetterParameterDefinition("mediaType", fromSimpleParameter("mediaType").build())
        .withSetterParameterDefinition("encoding", fromSimpleParameter("encoding").build())
        .build();
  }

  private ComponentBuildingDefinition buildDefaultFlowDefinition(String name) {
    InternalMessage.builder();
    return baseDefinition.copy()
        .withIdentifier(name)
        .withTypeDefinition(fromType(DefaultFlowBuilder.DefaultFlow.class))
        .withConstructorParameterDefinition(fromSimpleParameter("name").build())
        .withConstructorParameterDefinition(fromReferenceObject(MuleContext.class).build())
        .withSetterParameterDefinition("initialState", fromSimpleParameter("initialState").build())
        .withSetterParameterDefinition("messageSource", fromChildConfiguration(MessageSource.class).build())
        .withSetterParameterDefinition("messageProcessors", fromChildCollectionConfiguration(Processor.class).build())
        .withSetterParameterDefinition("exceptionListener",
                                       fromChildConfiguration(MessagingExceptionHandler.class).build())
        .withSetterParameterDefinition("processingStrategyFactory",
                                       fromSimpleReferenceParameter("processingStrategyFactory").build())
        .build();
  }

}
