package org.mule.munit.runner.remote.api.notifiers;

import org.mule.munit.common.protocol.notifiers.RunMessageNotifier;

import java.io.IOException;
import java.io.ObjectOutputStream;

/**
 * The goal of this class is to notify through a outputStream all events received though the interface {@link RunMessageNotifier}
 */
public class ObjectOutputStreamNotifier extends RunMessageNotifier {

  private ObjectOutputStream out;

  public ObjectOutputStreamNotifier(String runToken, ObjectOutputStream out) {
    this.setRunToken(runToken);
    this.out = out;
  }

  @Override
  public void init() throws Exception {

  }

  @Override
  public void sendMessage(String message) {
    try {
      out.writeObject(message);
      out.flush();
    } catch (IOException e) {
      throw new RuntimeException(e);
    }
  }

}
