/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.runner.processors;

import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.construct.Flow;

import reactor.core.publisher.Mono;

/**
 * Generic Flow Runner
 *
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
public class FlowRunner {

  private Flow flow;

  public FlowRunner(Flow flow) {
    this.flow = flow;
  }

  /**
   * It runs the flow with the provided event and wait for all asynchronous executions to finish
   * 
   * @param event the event to run the flow
   * @return the resulting event
   * @throws MuleException
   */
  public Event runSynchronously(Event event) throws MuleException {
    Event result = null;
    try {
      result = flow.process(event);
      // complete original event context on success
      event.getContext().success(result);
    } catch (Throwable t) {
      // Complete original event context on error
      event.getContext().error(t);
      throw t;
    } finally {
      // Wait for event completion
      buildBlocker(event).block();
    }
    return result;
  }

  protected Mono<Void> buildBlocker(Event event) {
    return Mono.from(event.getContext().getCompletionPublisher());
  }
}
