/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.runner.processors;


import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.DefaultEventContext;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.EventContext;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.exception.MessagingExceptionHandler;
import org.mule.runtime.core.api.lifecycle.LifecycleState;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategyFactory;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.core.management.stats.FlowConstructStatistics;

import javax.xml.namespace.QName;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import static org.mule.runtime.core.api.construct.Flow.builder;

/**
 * Generic MUnit Flow
 *
 * @author Mulesoft Inc.
 * @since 1.0.0
 */
public class MunitFlow implements Flow {

  private final Flow flow;
  private String description;

  protected Optional<Flow> behavior = Optional.empty();
  protected Optional<Flow> execution = Optional.empty();
  protected Optional<Flow> validation = Optional.empty();

  public Flow getBehavior() {
    return behavior.get();
  }

  public void setBehavior(Flow behavior) {
    this.behavior = Optional.ofNullable(behavior);
  }

  public Flow getExecution() {
    return execution.get();
  }

  public void setExecution(Flow execution) {
    this.execution = Optional.ofNullable(execution);
  }

  public Flow getValidation() {
    return validation.get();
  }

  public void setValidation(Flow validation) {
    this.validation = Optional.ofNullable(validation);
  }

  public MunitFlow(String name, MuleContext muleContext) {
    flow = builder(name, muleContext).build();
  }

  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  @Override
  public void dispose() {
    flow.dispose();

    behavior.ifPresent(Flow::dispose);
    execution.ifPresent(Flow::dispose);
    validation.ifPresent(Flow::dispose);
  }

  @Override
  public void initialise() throws InitialisationException {
    flow.initialise();
    if (behavior.isPresent()) {
      behavior.get().initialise();
    }
    if (execution.isPresent()) {
      execution.get().initialise();
    }
    if (validation.isPresent()) {
      validation.get().initialise();
    }
  }

  @Override
  public void start() throws MuleException {
    flow.start();
    if (behavior.isPresent()) {
      behavior.get().start();
    }
    if (execution.isPresent()) {
      execution.get().start();
    }
    if (validation.isPresent()) {
      validation.get().start();
    }
  }

  @Override
  public void stop() throws MuleException {
    flow.stop();
    if (behavior.isPresent()) {
      behavior.get().stop();
    }
    if (execution.isPresent()) {
      execution.get().stop();
    }
    if (validation.isPresent()) {
      validation.get().stop();
    }
  }

  @Override
  public Object getAnnotation(QName qName) {
    return flow.getAnnotation(qName);
  }

  @Override
  public Map<QName, Object> getAnnotations() {
    return flow.getAnnotations();
  }

  @Override
  public void setAnnotations(Map<QName, Object> map) {
    flow.setAnnotations(map);
  }

  @Override
  public ComponentLocation getLocation() {
    return flow.getLocation();
  }

  @Override
  public void setMessageSource(MessageSource messageSource) {
    flow.setMessageSource(messageSource);
  }

  @Override
  public MessageSource getMessageSource() {
    return flow.getMessageSource();
  }

  @Override
  public void setMessageProcessors(List<Processor> list) {
    flow.setMessageProcessors(list);
  }

  @Override
  public List<Processor> getMessageProcessors() {
    return flow.getMessageProcessors();
  }

  @Override
  public void setProcessingStrategyFactory(ProcessingStrategyFactory processingStrategyFactory) {
    flow.setProcessingStrategyFactory(processingStrategyFactory);
  }

  @Override
  public ProcessingStrategy getProcessingStrategy() {
    return flow.getProcessingStrategy();
  }

  @Override
  public Map<String, EventContext> getSerializationEventContextCache() {
    return flow.getSerializationEventContextCache();
  }

  @Override
  public ProcessingStrategyFactory getProcessingStrategyFactory() {
    return flow.getProcessingStrategyFactory();
  }

  @Override
  public MessagingExceptionHandler getExceptionListener() {
    return flow.getExceptionListener();
  }

  @Override
  public FlowConstructStatistics getStatistics() {
    return flow.getStatistics();
  }

  @Override
  public MuleContext getMuleContext() {
    return flow.getMuleContext();
  }

  @Override
  public String getUniqueIdString() {
    return flow.getUniqueIdString();
  }

  @Override
  public String getServerId() {
    return flow.getServerId();
  }

  @Override
  public String getName() {
    return flow.getName();
  }

  @Override
  public LifecycleState getLifecycleState() {
    return flow.getLifecycleState();
  }

  @Override
  public String getInitialState() {
    return flow.getInitialState();
  }

  @Override
  public boolean isSynchronous() {
    return flow.isSynchronous();
  }

  //TODO this sad code is due to MU-1038
  @Override
  public Event process(Event event) throws MuleException {
    if (!this.getClass().equals(MunitTestFlow.class)) {
      return flow.process(createChildEvent(event));
    }

    Event result = event;
    result = process(behavior, result);
    result = process(execution, result);
    return process(validation, result);
  }

  public Event process(Optional<Flow> flow, Event event) throws MuleException {
    if (flow.isPresent()) {
      return flow.get().process(createChildEvent(event));
    }
    return event;
  }

  private Event createChildEvent(Event event) {
    return Event.builder(DefaultEventContext.child(event.getContext()), event).build();
  }
}
